"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stopActionNameText = exports.isStopActionDisabled = exports.getStopActionDisabledMessage = exports.StopActionName = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _transform_list = require("../../../../common/transform_list");
var _create_stats_unknown_message = require("../../../../../../common/utils/create_stats_unknown_message");
var _constants = require("../../../../../../common/constants");
var _create_capability_failure_message = require("../../../../../../common/utils/create_capability_failure_message");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/action_stop/stop_action_name.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const stopActionNameText = exports.stopActionNameText = _i18n.i18n.translate('xpack.transform.transformList.stopActionNameText', {
  defaultMessage: 'Stop'
});
const getStopActionDisabledMessage = ({
  items,
  capabilities
}) => {
  const isBulkAction = items.length > 1;
  const {
    canStartStopTransform
  } = capabilities;
  if ((0, _transform_list.missingTransformStats)(items)) {
    return (0, _create_stats_unknown_message.createNoStatsTooltipMessage)({
      actionName: stopActionNameText,
      count: items.length
    });
  }

  // Disable stop action if one of the transforms is stopped already
  const stoppedTransform = items.some(i => (0, _transform_list.isTransformListRowWithStats)(i) && i.stats.state === _constants.TRANSFORM_STATE.STOPPED);
  if (!canStartStopTransform) {
    return (0, _create_capability_failure_message.createCapabilityFailureMessage)('canStartStopTransform');
  }
  if (stoppedTransform) {
    return isBulkAction === true ? _i18n.i18n.translate('xpack.transform.transformList.stoppedTransformBulkToolTip', {
      defaultMessage: 'One or more transforms are already stopped.'
    }) : _i18n.i18n.translate('xpack.transform.transformList.stoppedTransformToolTip', {
      defaultMessage: '{transformId} is already stopped.',
      values: {
        transformId: items[0] && items[0].config.id
      }
    });
  }
};
exports.getStopActionDisabledMessage = getStopActionDisabledMessage;
const isStopActionDisabled = (items, canStartStopTransform, forceDisable) => {
  // Disable stop action if one of the transforms is stopped already
  const stoppedTransform = items.some(i => {
    var _i$stats;
    return ((_i$stats = i.stats) === null || _i$stats === void 0 ? void 0 : _i$stats.state) === _constants.TRANSFORM_STATE.STOPPED;
  });
  return forceDisable === true || !canStartStopTransform || stoppedTransform === true || (0, _transform_list.missingTransformStats)(items);
};
exports.isStopActionDisabled = isStopActionDisabled;
const StopActionName = ({
  items,
  forceDisable
}) => {
  const capabilities = (0, _hooks.useTransformCapabilities)();
  // Disable transforms if stats does not exist
  const stoppedTransformMessage = getStopActionDisabledMessage({
    items,
    capabilities
  });
  if (forceDisable || stoppedTransformMessage) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: stoppedTransformMessage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 9
      }
    }, stopActionNameText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, stopActionNameText);
};
exports.StopActionName = StopActionName;