"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useReauthorizeAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _transform_list = require("../../../../common/transform_list");
var _sort_transforms_to_reauthorize = require("./sort_transforms_to_reauthorize");
var _reauthorization_utils = require("../../../../common/reauthorization_utils");
var _use_reauthorize_transform = require("../../../../hooks/use_reauthorize_transform");
var _reauthorize_action_name = require("./reauthorize_action_name");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/transform_management/components/action_reauthorize/use_reauthorize_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useReauthorizeAction = (forceDisable, transformNodes) => {
  const {
    canStartStopTransform
  } = (0, _hooks.useTransformCapabilities)();
  const reauthorizeTransforms = (0, _use_reauthorize_transform.useReauthorizeTransforms)();
  const [isModalVisible, setModalVisible] = (0, _react.useState)(false);
  const [items, setItems] = (0, _react.useState)([]);
  const closeModal = () => setModalVisible(false);
  const reauthorizeAndCloseModal = () => {
    setModalVisible(false);
    const {
      transformIds
    } = (0, _sort_transforms_to_reauthorize.sortTransformsToReauthorize)(items);
    reauthorizeTransforms(transformIds);
  };
  const openModal = newItems => {
    if (Array.isArray(newItems)) {
      setItems(newItems);
      setModalVisible(true);
    }
  };
  const action = (0, _react.useMemo)(() => ({
    name: item => /*#__PURE__*/_react.default.createElement(_reauthorize_action_name.ReauthorizeActionName, {
      items: [item],
      forceDisable: forceDisable,
      transformNodes: transformNodes,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }),
    available: item => (0, _reauthorization_utils.needsReauthorization)(item),
    enabled: item => (0, _transform_list.isTransformListRowWithStats)(item) && !(0, _reauthorize_action_name.isReauthorizeActionDisabled)([item], canStartStopTransform, transformNodes),
    description: _reauthorize_action_name.reauthorizeActionNameText,
    icon: 'alert',
    type: 'icon',
    color: 'warning',
    onClick: item => openModal([item]),
    'data-test-subj': 'transformActionReauthorize'
  }), [canStartStopTransform, forceDisable, transformNodes]);
  return {
    action,
    closeModal,
    isModalVisible,
    items,
    openModal,
    reauthorizeAndCloseModal
  };
};
exports.useReauthorizeAction = useReauthorizeAction;