"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsFormTouched = void 0;
var _lodash = require("lodash");
var _react = require("react");
var _toolkit = require("@reduxjs/toolkit");
var _reactRedux = require("react-redux");
var _get_default_state = require("../get_default_state");
var _edit_transform_flyout_state = require("../edit_transform_flyout_state");
var _form_field = require("./form_field");
var _form_sections = require("./form_sections");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFieldValues = fields => Object.values(fields).map(f => f.value);
const getSectionValues = sections => Object.values(sections).map(s => s.enabled);
const isFormTouched = (config, formFields, formSections) => {
  const defaultState = (0, _get_default_state.getDefaultState)(config);
  return !(0, _lodash.isEqual)(getFieldValues(defaultState.formFields), getFieldValues(formFields)) || !(0, _lodash.isEqual)(getSectionValues(defaultState.formSections), getSectionValues(formSections));
};
const createSelectIsFormTouched = originalConfig => (0, _toolkit.createSelector)(_form_field.selectFormFields, _form_sections.selectFormSections, (formFields, formSections) => isFormTouched(originalConfig, formFields, formSections));
const useIsFormTouched = () => {
  const {
    config
  } = (0, _edit_transform_flyout_state.useEditTransformFlyoutContext)();
  const selectIsFormTouched = (0, _react.useMemo)(() => createSelectIsFormTouched(config), [config]);
  return (0, _reactRedux.useSelector)(selectIsFormTouched);
};
exports.useIsFormTouched = useIsFormTouched;