"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditTransformFlyoutContext = exports.useEditTransformFlyoutActions = exports.EditTransformFlyoutProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _toolkit = require("@reduxjs/toolkit");
var _reactRedux = require("react-redux");
var _redux = require("redux");
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _actions = require("./actions");
var _get_default_state = require("./get_default_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/edit_transform/state_management/edit_transform_flyout_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// The edit transform flyout uses a redux-toolkit to manage its form state with
// support for applying its state to a nested configuration object suitable for passing on
// directly to the API call. For now this is only used for the transform edit form.
// Once we apply the functionality to other places, e.g. the transform creation wizard,
// the generic framework code in this file should be moved to a dedicated location.

const editTransformFlyoutSlice = (0, _toolkit.createSlice)({
  name: 'editTransformFlyout',
  initialState: (0, _get_default_state.getDefaultState)(),
  reducers: {
    initialize: _actions.initialize,
    setApiError: _actions.setApiError,
    setFormField: _actions.setFormField,
    setFormSection: _actions.setFormSection
  }
});
const getReduxStore = () => (0, _toolkit.configureStore)({
  reducer: editTransformFlyoutSlice.reducer
});
const EditTransformFlyoutContext = /*#__PURE__*/(0, _react.createContext)(null);
const EditTransformFlyoutProvider = ({
  children,
  ...props
}) => {
  const store = (0, _react.useMemo)(getReduxStore, []);

  // Apply original transform config to redux form state.
  (0, _useMount.default)(() => {
    store.dispatch(editTransformFlyoutSlice.actions.initialize(props));
  });
  return /*#__PURE__*/_react.default.createElement(EditTransformFlyoutContext.Provider, {
    value: props,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, children));
};
exports.EditTransformFlyoutProvider = EditTransformFlyoutProvider;
const useEditTransformFlyoutContext = () => {
  const c = (0, _react.useContext)(EditTransformFlyoutContext);
  if (c === null) throw new Error('EditTransformFlyoutContext not set.');
  return c;
};
exports.useEditTransformFlyoutContext = useEditTransformFlyoutContext;
const useEditTransformFlyoutActions = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  return (0, _react.useMemo)(() => (0, _redux.bindActionCreators)(editTransformFlyoutSlice.actions, dispatch), [dispatch]);
};
exports.useEditTransformFlyoutActions = useEditTransformFlyoutActions;