"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LatestFunctionForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mlFieldStatsFlyout = require("@kbn/ml-field-stats-flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/step_define/latest_function_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LatestFunctionForm = ({
  copyToClipboard,
  copyToClipboardDescription,
  latestFunctionService
}) => {
  var _latestFunctionServic;
  const {
    renderOption,
    closeFlyout
  } = (0, _mlFieldStatsFlyout.useFieldStatsTrigger)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.stepDefineForm.uniqueKeysLabel",
      defaultMessage: "Unique keys",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 11
      }
    }),
    "data-test-subj": "transformLatestFunctionForm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.transform.stepDefineForm.uniqueKeysPlaceholder', {
      defaultMessage: 'Add unique keys ...'
    }),
    options: latestFunctionService.uniqueKeyOptions,
    selectedOptions: (_latestFunctionServic = latestFunctionService.config.unique_key) !== null && _latestFunctionServic !== void 0 ? _latestFunctionServic : [],
    onChange: selected => {
      latestFunctionService.updateLatestFunctionConfig({
        unique_key: selected
      });
      closeFlyout();
    },
    isClearable: false,
    "data-test-subj": "transformWizardUniqueKeysSelector",
    renderOption: renderOption,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.stepDefineForm.sortLabel",
      defaultMessage: "Sort field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    }),
    helpText: latestFunctionService.sortFieldOptions.length > 0 ? _i18n.i18n.translate('xpack.transform.stepDefineForm.sortHelpText', {
      defaultMessage: 'Select the date field to be used to identify the latest document.'
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, latestFunctionService.sortFieldOptions.length > 0 && /*#__PURE__*/_react.default.createElement(_mlFieldStatsFlyout.OptionListWithFieldStats, {
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.transform.stepDefineForm.sortPlaceholder', {
      defaultMessage: 'Add a date field ...'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: latestFunctionService.sortFieldOptions,
    selectedOptions: latestFunctionService.config.sort ? [latestFunctionService.config.sort] : [],
    onChange: selected => {
      if (typeof selected[0].value === 'string') {
        var _selected$0$label;
        latestFunctionService.updateLatestFunctionConfig({
          sort: {
            value: selected[0].value,
            label: (_selected$0$label = selected[0].label) === null || _selected$0$label === void 0 ? void 0 : _selected$0$label.toString()
          }
        });
      }
      closeFlyout();
    },
    isClearable: false,
    "data-test-subj": "transformWizardSortFieldSelector",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }), latestFunctionService.sortFieldOptions.length === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.transform.stepDefineForm.sortFieldOptionsEmptyError",
    defaultMessage: "No date fields are available to sort on. To use another field type, copy the configuration to the clipboard and continue creating the transform in the Console.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 17
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    beforeMessage: copyToClipboardDescription,
    textToCopy: copyToClipboard,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 17
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    onClick: copy,
    iconType: "copyClipboard",
    "aria-label": copyToClipboardDescription,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 21
    }
  })))))));
};
exports.LatestFunctionForm = LatestFunctionForm;