"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultStepDefineState = getDefaultStepDefineState;
var _constants = require("./constants");
var _constants2 = require("../../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDefaultStepDefineState(searchItems) {
  return {
    transformFunction: _constants2.TRANSFORM_FUNCTION.PIVOT,
    latestConfig: {},
    aggList: {},
    groupByList: {},
    isAdvancedPivotEditorEnabled: false,
    isAdvancedSourceEditorEnabled: false,
    isDatePickerApplyEnabled: false,
    searchLanguage: _constants.QUERY_LANGUAGE_KUERY,
    searchString: undefined,
    searchQuery: searchItems.savedSearch !== undefined ? searchItems.combinedQuery : _constants.defaultSearch,
    sourceConfigUpdated: false,
    valid: false,
    validationStatus: {
      isValid: false
    },
    previewRequest: undefined,
    runtimeMappings: undefined,
    runtimeMappingsUpdated: false,
    isRuntimeMappingsEditorEnabled: false
  };
}