"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterAggsFieldSupport = exports.commonFilterAggs = exports.FILTERS = void 0;
var _fieldTypes = require("@kbn/field-types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILTERS = exports.FILTERS = {
  CUSTOM: 'custom',
  PHRASES: 'phrases',
  PHRASE: 'phrase',
  EXISTS: 'exists',
  MATCH_ALL: 'match_all',
  MISSING: 'missing',
  QUERY_STRING: 'query_string',
  RANGE: 'range',
  GEO_BOUNDING_BOX: 'geo_bounding_box',
  GEO_POLYGON: 'geo_polygon',
  SPATIAL_FILTER: 'spatial_filter',
  TERM: 'term',
  TERMS: 'terms',
  BOOL: 'bool'
};
const filterAggsFieldSupport = exports.filterAggsFieldSupport = {
  [_fieldTypes.KBN_FIELD_TYPES.ATTACHMENT]: [],
  [_fieldTypes.KBN_FIELD_TYPES.BOOLEAN]: [],
  [_fieldTypes.KBN_FIELD_TYPES.DATE]: [FILTERS.RANGE],
  [_fieldTypes.KBN_FIELD_TYPES.GEO_POINT]: [FILTERS.GEO_BOUNDING_BOX, FILTERS.GEO_POLYGON],
  [_fieldTypes.KBN_FIELD_TYPES.GEO_SHAPE]: [FILTERS.GEO_BOUNDING_BOX, FILTERS.GEO_POLYGON],
  [_fieldTypes.KBN_FIELD_TYPES.IP]: [FILTERS.RANGE],
  [_fieldTypes.KBN_FIELD_TYPES.MURMUR3]: [],
  [_fieldTypes.KBN_FIELD_TYPES.NUMBER]: [FILTERS.RANGE],
  [_fieldTypes.KBN_FIELD_TYPES.STRING]: [FILTERS.TERM],
  [_fieldTypes.KBN_FIELD_TYPES._SOURCE]: [],
  [_fieldTypes.KBN_FIELD_TYPES.UNKNOWN]: [],
  [_fieldTypes.KBN_FIELD_TYPES.CONFLICT]: []
};
const commonFilterAggs = exports.commonFilterAggs = [FILTERS.BOOL, FILTERS.EXISTS];