"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopoverForm = void 0;
exports.isIntervalValid = isIntervalValid;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _time_zone_utils = require("../../../../common/time_zone_utils");
var _common = require("../../../../../../common/types/common");
var _use_documentation_links = require("../../../../hooks/use_documentation_links");
var _common2 = require("../../../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/sections/create_transform/components/group_by_list/popover_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isIntervalValid(interval, intervalType) {
  if (interval !== '' && interval !== undefined) {
    if (intervalType === _common2.PIVOT_SUPPORTED_GROUP_BY_AGGS.HISTOGRAM) {
      if (!_common2.histogramIntervalFormatRegex.test(interval)) {
        return false;
      }
      if (parseFloat(interval) === 0 && parseInt(interval, 10) === 0) {
        return false;
      }
      return true;
    } else if (intervalType === _common2.PIVOT_SUPPORTED_GROUP_BY_AGGS.DATE_HISTOGRAM) {
      if (!_common2.dateHistogramIntervalFormatRegex.test(interval)) {
        return false;
      }
      const timeUnitMatch = interval.match(_common2.dateHistogramIntervalFormatRegex);
      if (timeUnitMatch !== null && Array.isArray(timeUnitMatch) && timeUnitMatch.length === 2) {
        const timeUnit = timeUnitMatch[1];
        const intervalNum = parseInt(interval.replace(timeUnit, ''), 10);
        if ((timeUnit === 'w' || timeUnit === 'M' || timeUnit === 'y') && intervalNum > 1) {
          return false;
        }
      }
      return true;
    }
  }
  return false;
}
function getDefaultInterval(defaultData) {
  if ((0, _common2.isGroupByDateHistogram)(defaultData)) {
    return defaultData.calendar_interval;
  } else if ((0, _common2.isGroupByHistogram)(defaultData)) {
    return defaultData.interval;
  }
  return undefined;
}
const PopoverForm = ({
  defaultData,
  otherAggNames,
  onChange,
  options
}) => {
  const {
    esAggsCompositeMissingBucket
  } = (0, _use_documentation_links.useDocumentationLinks)();
  const isUnsupportedAgg = !(0, _common2.isPivotGroupByConfigWithUiSupport)(defaultData);
  const [agg, setAgg] = (0, _react.useState)(defaultData.agg);
  const [aggName, setAggName] = (0, _react.useState)(defaultData.aggName);
  const [field, setField] = (0, _react.useState)((0, _common2.isPivotGroupByConfigWithUiSupport)(defaultData) ? defaultData.field : '');
  const [interval, setInterval] = (0, _react.useState)(getDefaultInterval(defaultData));
  const TIMEZONE_OPTIONS = (0, _react.useMemo)(() => [..._time_zone_utils.ACCEPTED_TIMEZONES].map(value => ({
    value,
    label: value
  })), []);

  // Should default to time zone that user sets in json editor first
  const [selectedTimeZone, setSelectedTimeZone] = (0, _react.useState)((0, _common2.isGroupByDateHistogram)(defaultData) && (0, _time_zone_utils.isValidTimeZone)(defaultData.time_zone) ? [TIMEZONE_OPTIONS.find(v => v.value === defaultData.time_zone)] : []);
  const timeZone = (0, _react.useMemo)(() => {
    var _selectedTimeZone$;
    return (_selectedTimeZone$ = selectedTimeZone[0]) === null || _selectedTimeZone$ === void 0 ? void 0 : _selectedTimeZone$.value;
  }, [selectedTimeZone]);
  const [missingBucket, setMissingBucket] = (0, _react.useState)((0, _common2.isPivotGroupByConfigWithUiSupport)(defaultData) && defaultData.missing_bucket);
  const missingBucketSwitchId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  function getUpdatedItem() {
    const updatedItem = {
      ...defaultData,
      agg,
      aggName,
      field,
      missing_bucket: missingBucket
    };
    if ((0, _common2.isGroupByHistogram)(updatedItem) && interval !== undefined) {
      updatedItem.interval = interval;
    } else if ((0, _common2.isGroupByDateHistogram)(updatedItem) && interval !== undefined) {
      updatedItem.calendar_interval = interval;
      if ((0, _time_zone_utils.isValidTimeZone)(timeZone)) {
        updatedItem.time_zone = timeZone;
      }
    }

    // Casting to PivotGroupByConfig because TS would otherwise complain about the
    // PIVOT_SUPPORTED_GROUP_BY_AGGS type for `agg`.
    return updatedItem;
  }
  const availableFields = [];
  const availableAggs = [];
  if (!isUnsupportedAgg) {
    const optionsArr = (0, _common.dictionaryToArray)(options);
    optionsArr.filter(o => o.agg === defaultData.agg).forEach(o => {
      availableFields.push({
        text: o.field
      });
    });
    optionsArr.filter(o => (0, _common2.isPivotGroupByConfigWithUiSupport)(defaultData) && o.field === defaultData.field).forEach(o => {
      availableAggs.push({
        text: o.agg
      });
    });
  }
  let aggNameError = '';
  let validAggName = (0, _common2.isAggName)(aggName);
  if (!validAggName) {
    aggNameError = _i18n.i18n.translate('xpack.transform.groupBy.popoverForm.aggNameInvalidCharError', {
      defaultMessage: 'Invalid name. The characters "[", "]", and ">" are not allowed and the name must not start or end with a space character.'
    });
  }
  if (validAggName) {
    validAggName = !otherAggNames.includes(aggName);
    aggNameError = _i18n.i18n.translate('xpack.transform.groupBy.popoverForm.aggNameAlreadyUsedError', {
      defaultMessage: 'Another group by configuration already uses that name.'
    });
  }
  const validInterval = ((0, _common2.isGroupByDateHistogram)(defaultData) || (0, _common2.isGroupByHistogram)(defaultData)) && isIntervalValid(interval, defaultData.agg);
  const timeZoneValid = (0, _common2.isGroupByDateHistogram)(defaultData) && (0, _time_zone_utils.isValidTimeZone)(timeZone);
  let formValid = validAggName;
  if (formValid && ((0, _common2.isGroupByDateHistogram)(defaultData) || (0, _common2.isGroupByHistogram)(defaultData))) {
    formValid = isIntervalValid(interval, defaultData.agg);
    if ((0, _common2.isGroupByDateHistogram)(defaultData) && (0, _mlIsDefined.isDefined)(defaultData.time_zone)) {
      formValid = timeZoneValid;
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    style: {
      width: '300px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: !validAggName && [aggNameError],
    isInvalid: !validAggName,
    helpText: isUnsupportedAgg ? _i18n.i18n.translate('xpack.transform.groupBy.popoverForm.unsupportedGroupByHelpText', {
      defaultMessage: 'Only the group_by name can be edited in this form. Please use the advanced editor to edit the other parts of the group_by configuration.'
    }) : '',
    label: _i18n.i18n.translate('xpack.transform.groupBy.popoverForm.nameLabel', {
      defaultMessage: 'Group by name'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: aggName,
    isInvalid: !validAggName,
    onChange: e => setAggName(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 9
    }
  })), availableAggs.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.groupby.popoverForm.aggLabel', {
      defaultMessage: 'Aggregation'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: availableAggs,
    value: agg,
    onChange: e => setAgg(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 11
    }
  })), availableFields.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.transform.groupBy.popoverForm.fieldLabel', {
      defaultMessage: 'Field'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: availableFields,
    value: field,
    onChange: e => setField(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 11
    }
  })), ((0, _common2.isGroupByDateHistogram)(defaultData) || (0, _common2.isGroupByHistogram)(defaultData)) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: [_i18n.i18n.translate('xpack.transform.groupBy.popoverForm.intervalError', {
      defaultMessage: 'Invalid interval.'
    })],
    isInvalid: !validInterval,
    label: _i18n.i18n.translate('xpack.transform.groupBy.popoverForm.intervalLabel', {
      defaultMessage: 'Interval'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _common2.isGroupByHistogram)(defaultData) && /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    defaultValue: interval,
    isInvalid: !validInterval,
    onChange: e => setInterval(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 15
    }
  }), (0, _common2.isGroupByDateHistogram)(defaultData) && /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: [{
      value: '1m',
      text: '1m'
    }, {
      value: '1h',
      text: '1h'
    }, {
      value: '1d',
      text: '1d'
    }, {
      value: '1w',
      text: '1w'
    }, {
      value: '1M',
      text: '1M'
    }, {
      value: '1q',
      text: '1q'
    }, {
      value: '1y',
      text: '1y'
    }],
    value: interval,
    onChange: e => setInterval(e.target.value),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 15
    }
  }))), (0, _common2.isGroupByDateHistogram)(defaultData) && (0, _mlIsDefined.isDefined)(defaultData.time_zone) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: _i18n.i18n.translate('xpack.transform.groupBy.popoverForm.timeZoneError', {
      defaultMessage: 'Invalid time zone.'
    }),
    isInvalid: !timeZoneValid,
    label: _i18n.i18n.translate('xpack.transform.groupBy.popoverForm.timeZoneLabel', {
      defaultMessage: 'Time zone'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: !timeZoneValid,
    options: TIMEZONE_OPTIONS,
    onChange: opt => setSelectedTimeZone(opt),
    selectedOptions: selectedTimeZone,
    "aria-label": _i18n.i18n.translate('xpack.transform.groupBy.popoverForm.timeZoneAriaLabel', {
      defaultMessage: 'Time zone'
    }),
    singleSelection: {
      asPlainText: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 11
    }
  })) : null, !isUnsupportedAgg && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.transform.groupBy.popoverForm.missingBucketCheckboxHelpText', {
      defaultMessage: 'Select to include documents without a value.'
    }), /*#__PURE__*/_react.default.createElement("br", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 324,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: esAggsCompositeMissingBucket,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 325,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.transform.stepDetailsForm.missingBucketCheckboxHelpTextLink', {
      defaultMessage: `Learn more`
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: missingBucketSwitchId,
    label: _i18n.i18n.translate('xpack.transform.groupby.popoverForm.missingBucketCheckboxLabel', {
      defaultMessage: 'Include missing buckets'
    }),
    checked: missingBucket,
    onChange: () => setMissingBucket(!missingBucket),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 11
    }
  })), isUnsupportedAgg && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    "aria-label": _i18n.i18n.translate('xpack.transform.agg.popoverForm.codeBlock', {
      defaultMessage: 'JSON of transform aggregation'
    }),
    fontSize: "s",
    language: "json",
    paddingSize: "s",
    style: {
      width: '100%',
      height: '200px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 11
    }
  }, JSON.stringify((0, _common2.getEsAggFromGroupByConfig)(defaultData), null, 2))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: !formValid,
    onClick: () => onChange(getUpdatedItem()),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 366,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.transform.groupBy.popoverForm.submitButtonLabel', {
    defaultMessage: 'Apply'
  }))));
};
exports.PopoverForm = PopoverForm;