"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformSettingsPageSearchSizeValidator = void 0;
var _i18n = require("@kbn/i18n");
var _mlAggUtils = require("@kbn/ml-agg-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pageSearchSizeInvalidErrorMessage = _i18n.i18n.translate('xpack.transform.transformSettingValidations.maxPageSearchSizeInvalidMessage', {
  defaultMessage: 'Maximum page search size needs to be an integer between 10 and 65536.'
});

// memoize validator
const validator = (0, _mlAggUtils.numberValidator)({
  min: 10,
  max: 65536,
  integerOnly: true
});

/**
 * Validates transform max_page_search_size input.
 * Must be a number between 10 and 65536.
 * @param value User input value.
 */
const transformSettingsPageSearchSizeValidator = value => validator(+value) === null ? [] : [pageSearchSizeInvalidErrorMessage];
exports.transformSettingsPageSearchSizeValidator = transformSettingsPageSearchSizeValidator;