"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retentionPolicyMaxAgeValidator = void 0;
var _messages = require("./messages");
var _parse_duration_above_zero = require("./parse_duration_above_zero");
var _is_retention_policy_max_age = require("./is_retention_policy_max_age");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Validates retention policy max age input.
 * Doesn't allow floating intervals.
 * @param value User input value. Minimum of 60s.
 */
const retentionPolicyMaxAgeValidator = arg => {
  const parsedArg = (0, _parse_duration_above_zero.parseDurationAboveZero)(arg);
  if (Array.isArray(parsedArg)) {
    return parsedArg;
  }

  // We pass in again the original `arg`, not `parsedArg` since it will parse it again.
  return (0, _is_retention_policy_max_age.isRetentionPolicyMaxAge)(arg) ? [] : [_messages.retentionPolicyMaxAgeInvalidErrorMessage];
};
exports.retentionPolicyMaxAgeValidator = retentionPolicyMaxAgeValidator;