"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultSelectableFields = void 0;
exports.getFlattenedFields = getFlattenedFields;
exports.toggleSelectedField = exports.getSelectableFields = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getFlattenedFields(obj) {
  const flatDocFields = [];
  const newDocFields = Object.keys(obj);
  newDocFields.forEach(f => {
    const fieldValue = obj[f];
    if (typeof fieldValue !== 'object' || fieldValue === null || Array.isArray(fieldValue)) {
      flatDocFields.push(f);
    } else {
      const innerFields = getFlattenedFields(fieldValue);
      const flattenedFields = innerFields.map(d => `${f}.${d}`);
      flatDocFields.push(...flattenedFields);
    }
  });
  return flatDocFields;
}
const getSelectableFields = docs => {
  if (docs.length === 0) {
    return [];
  }
  const newDocFields = getFlattenedFields(docs[0]);
  newDocFields.sort();
  return newDocFields;
};
exports.getSelectableFields = getSelectableFields;
const getDefaultSelectableFields = docs => {
  if (docs.length === 0) {
    return [];
  }
  const newDocFields = getFlattenedFields(docs[0]);
  newDocFields.sort();
  return newDocFields.filter(k => {
    let value = false;
    docs.forEach(row => {
      const source = row;
      if (source[k] !== null) {
        value = true;
      }
    });
    return value;
  });
};
exports.getDefaultSelectableFields = getDefaultSelectableFields;
const toggleSelectedField = (selectedFields, column) => {
  const index = selectedFields.indexOf(column);
  if (index === -1) {
    selectedFields.push(column);
  } else {
    selectedFields.splice(index, 1);
  }
  selectedFields.sort();
  return selectedFields;
};
exports.toggleSelectedField = toggleSelectedField;