"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = exports.App = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _reactQuery = require("@tanstack/react-query");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _constants = require("./common/constants");
var _clone_transform = require("./sections/clone_transform");
var _create_transform = require("./sections/create_transform");
var _transform_management = require("./sections/transform_management");
var _serverless_context = require("./serverless_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/transform/public/app/app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const App = ({
  history
}) => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
  history: history,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 31,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: `/${_constants.SECTION_SLUG.CLONE_TRANSFORM}/:transformId`,
  component: _clone_transform.CloneTransformSection,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 32,
    columnNumber: 7
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: `/${_constants.SECTION_SLUG.CREATE_TRANSFORM}/:savedObjectId`,
  component: _create_transform.CreateTransformSection,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 7
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: `/`,
  component: _transform_management.TransformManagementSection,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 7
  }
})));
exports.App = App;
const renderApp = (element, appDependencies, enabledFeatures, experimentalFeatures) => {
  const queryClient = new _reactQuery.QueryClient({
    defaultOptions: {
      queries: {
        staleTime: Infinity,
        retry: false
      }
    }
  });
  (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, appDependencies, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: appDependencies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_serverless_context.EnabledFeaturesContextProvider, {
    enabledFeatures: enabledFeatures,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_serverless_context.ExperimentalFeaturesContextProvider, {
    experimentalFeatures: experimentalFeatures,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(App, {
    history: appDependencies.history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 15
    }
  })))))), element);
  return () => {
    (0, _reactDom.unmountComponentAtNode)(element);
  };
};
exports.renderApp = renderApp;