"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRANSFORM_ACTIONS = void 0;
exports.isContinuousTransform = isContinuousTransform;
exports.isLatestTransform = isLatestTransform;
exports.isPivotTransform = isPivotTransform;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Generic type for transform response
 */

/**
 * Transform with pivot configuration
 */

/**
 * Transform with latest function configuration
 */

function isPivotTransform(transform) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(transform, ['pivot']);
}
function isLatestTransform(transform) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(transform, ['latest']);
}
function isContinuousTransform(transform) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(transform, ['sync']);
}
let TRANSFORM_ACTIONS = exports.TRANSFORM_ACTIONS = /*#__PURE__*/function (TRANSFORM_ACTIONS) {
  TRANSFORM_ACTIONS["DELETE"] = "delete";
  TRANSFORM_ACTIONS["REAUTHORIZE"] = "reauthorize";
  TRANSFORM_ACTIONS["RESET"] = "reset";
  TRANSFORM_ACTIONS["SCHEDULE_NOW"] = "schedule_now";
  TRANSFORM_ACTIONS["STOP"] = "stop";
  TRANSFORM_ACTIONS["START"] = "start";
  return TRANSFORM_ACTIONS;
}({});