"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unionWithNullType = exports.assertUnreachable = void 0;
var runtimeTypes = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const unionWithNullType = type => runtimeTypes.union([type, runtimeTypes.null]);

/**
 * Unreachable Assertion helper for scenarios like exhaustive switches.
 * For references see: https://stackoverflow.com/questions/39419170/how-do-i-check-that-a-switch-block-is-exhaustive-in-typescript
 * This "x" should _always_ be a type of "never" and not change to "unknown" or any other type. See above link or the generic
 * concept of exhaustive checks in switch blocks.
 *
 * Optionally you can avoid the use of this by using early returns and TypeScript will clear your type checking without complaints
 * but there are situations and times where this function might still be needed.
 *
 * If you see an error, DO NOT cast "as never" such as:
 * assertUnreachable(x as never) // BUG IN YOUR CODE NOW AND IT WILL THROW DURING RUNTIME
 * If you see code like that remove it, as that deactivates the intent of this utility.
 * If you need to do that, then you should remove assertUnreachable from your code and
 * use a default at the end of the switch instead.
 * @param x Unreachable field
 * @param message Message of error thrown
 */
exports.unionWithNullType = unionWithNullType;
const assertUnreachable = (x,
// This should always be a type of "never"
message = 'Unknown Field in switch statement') => {
  throw new Error(`${message}: ${x}`);
};
exports.assertUnreachable = assertUnreachable;