"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptInMessage = void 0;
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/telemetry/public/components/opt_in_message.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OptInMessage = ({
  addBasePath,
  telemetryService,
  telemetryConstants,
  onClick
}) => {
  return /*#__PURE__*/React.createElement(React.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
    id: "telemetry.dataManagementDisclaimerPrivacy",
    defaultMessage: "{optInStatus} This allows us to learn what our users are most interested in, so we can improve our products and services. Refer to our {privacyStatementLink}.",
    values: {
      optInStatus: /*#__PURE__*/React.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 13
        }
      }, telemetryService.isOptedIn ? /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.enabledStatus",
        defaultMessage: "Usage collection is enabled.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 17
        }
      }) : /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.disabledStatus",
        defaultMessage: "Usage collection is disabled.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 17
        }
      })),
      privacyStatementLink:
      /*#__PURE__*/
      /* eslint-disable-next-line @elastic/eui/href-or-on-click */
      React.createElement(_eui.EuiLink, {
        onClick: onClick,
        href: telemetryConstants.getPrivacyStatementUrl(),
        target: "_blank",
        rel: "noopener",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 13
        }
      }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "telemetry.dataManagementDisclaimerPrivacyLink",
        defaultMessage: "Privacy Statement",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }), ' ', renderTelemetryEnabledOrDisabledText(telemetryService, addBasePath, onClick));
};
exports.OptInMessage = OptInMessage;
function renderTelemetryEnabledOrDisabledText(telemetryService, addBasePath, onClick) {
  if (!telemetryService.userCanChangeSettings || !telemetryService.getCanChangeOptInStatus()) {
    return null;
  }
  const isOptedIn = telemetryService.getIsOptedIn();
  const actionMessage = isOptedIn ? /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
    id: "telemetry.dataManagementDisableCollectionLink",
    defaultMessage: "Disable usage collection.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }) : /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
    id: "telemetry.dataManagementEnableCollectionLink",
    defaultMessage: "Enable usage collection.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/ /* eslint-disable-next-line @elastic/eui/href-or-on-click */React.createElement(_eui.EuiLink, {
    href: addBasePath(_constants.PATH_TO_ADVANCED_SETTINGS),
    onClick: onClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, actionMessage);
}