"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.telemetryConfigSchemaProps = exports.telemetryConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _tracingConfig = require("@kbn/tracing-config");
var _metricsConfig = require("@kbn/metrics-config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Properties to use in the {@link telemetryConfigSchema}.
 * They are exported separately because they are used by the telemetry plugin to extend its config schema
 * since everything is in the same `telemetry.*` config path.
 *
 * @internal
 */
const telemetryConfigSchemaProps = exports.telemetryConfigSchemaProps = {
  /**
   * Global toggle for telemetry. It disables all form of telemetry: product analytics, OTel tracing and OTel metrics.
   */
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  /** The {@link tracingConfigSchema | tracing config schema} */
  tracing: _tracingConfig.tracingConfigSchema,
  /** The {@link metricsConfigSchema | metrics config schema} */
  metrics: _metricsConfig.metricsConfigSchema
};

/**
 * Schema for the OpenTelemetry configuration
 */
const telemetryConfigSchema = exports.telemetryConfigSchema = _configSchema.schema.object(telemetryConfigSchemaProps);