"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getElasticsearchAndSOAvailability = getElasticsearchAndSOAvailability;
var _rxjs = require("rxjs");
var _server = require("@kbn/core/server");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getElasticsearchAndSOAvailability({
  core$,
  isServerless,
  logger,
  getClusterClient
}) {
  let isEsHealthy = false;
  let isEsServiceAvailable = false;
  let isSoServiceAvailable = false;
  const result = new _rxjs.BehaviorSubject(false);
  core$.subscribe(({
    elasticsearch,
    savedObjects
  }) => {
    isEsServiceAvailable = elasticsearch.level === _server.ServiceStatusLevels.available;
    isSoServiceAvailable = savedObjects.level === _server.ServiceStatusLevels.available;
    result.next(isEsHealthy && isEsServiceAvailable && isSoServiceAvailable);
  });
  // Load cluster health to ensure task index is ready
  getClusterClient().then(client => {
    client.asInternalUser.cluster.health({
      wait_for_status: isServerless ? 'green' : 'yellow',
      timeout: '30s',
      index: _constants.TASK_MANAGER_INDEX
    }).then(healthResult => {
      logger.debug(`Cluster health: ${JSON.stringify(healthResult)}`);
      isEsHealthy = true;
      result.next(isEsHealthy && isEsServiceAvailable && isSoServiceAvailable);
    }).catch(e => {
      logger.error(`Error loading the cluster health. The task poller will start regardless. Error: ${e.message}`);
      // Even if we can't load the cluster health, we should start the task
      // poller in case the issue is unrelated.
      isEsHealthy = true;
      result.next(isEsHealthy && isEsServiceAvailable && isSoServiceAvailable);
    });
  }).catch(e => {
    logger.error(`Error loading the cluster client to fetch cluster health. The task poller will start regardless. Error: ${e.message}`);
    // Even if we can't load the cluster health, we should start the task
    // poller in case the issue is unrelated.
    isEsHealthy = true;
    result.next(isEsHealthy && isEsServiceAvailable && isSoServiceAvailable);
  });
  return result;
}