"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkUpdateError = void 0;
exports.getBulkUpdateErrorType = getBulkUpdateErrorType;
exports.getBulkUpdateStatusCode = getBulkUpdateStatusCode;
exports.isClusterBlockException = isClusterBlockException;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class BulkUpdateError extends Error {
  constructor({
    statusCode,
    message = 'Bulk update failed with unknown reason',
    type
  }) {
    super(message);
    (0, _defineProperty2.default)(this, "_statusCode", void 0);
    (0, _defineProperty2.default)(this, "_type", void 0);
    this._statusCode = statusCode;
    this._type = type;
  }
  get statusCode() {
    return this._statusCode;
  }
  get type() {
    return this._type;
  }
}
exports.BulkUpdateError = BulkUpdateError;
function getBulkUpdateStatusCode(error) {
  if (Boolean(error && error instanceof BulkUpdateError)) {
    return error.statusCode;
  }
}
function getBulkUpdateErrorType(error) {
  if (Boolean(error && error instanceof BulkUpdateError)) {
    return error.type;
  }
}
function isClusterBlockException(error) {
  return getBulkUpdateErrorType(error) === 'cluster_block_exception' || error.message.includes('cluster_block_exception');
}