"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @generated by Peggy 4.0.3.
//
// https://peggyjs.org/

function peg$subclass(child, parent) {
  function C() {
    this.constructor = child;
  }
  C.prototype = parent.prototype;
  child.prototype = new C();
}
function peg$SyntaxError(message, expected, found, location) {
  const self = Error.call(this, message);
  // istanbul ignore next Check is a necessary evil to support older environments
  if (Object.setPrototypeOf) {
    Object.setPrototypeOf(self, peg$SyntaxError.prototype);
  }
  self.expected = expected;
  self.found = found;
  self.location = location;
  self.name = 'SyntaxError';
  return self;
}
peg$subclass(peg$SyntaxError, Error);
function peg$padEnd(str, targetLength, padString) {
  padString = padString || ' ';
  if (str.length > targetLength) {
    return str;
  }
  targetLength -= str.length;
  padString += padString.repeat(targetLength);
  return str + padString.slice(0, targetLength);
}
peg$SyntaxError.prototype.format = function (sources) {
  let str = 'Error: ' + this.message;
  if (this.location) {
    let src = null;
    let k;
    for (k = 0; k < sources.length; k++) {
      if (sources[k].source === this.location.source) {
        src = sources[k].text.split(/\r\n|\n|\r/g);
        break;
      }
    }
    const s = this.location.start;
    const offsetS = this.location.source && typeof this.location.source.offset === 'function' ? this.location.source.offset(s) : s;
    const loc = this.location.source + ':' + offsetS.line + ':' + offsetS.column;
    if (src) {
      const e = this.location.end;
      const filler = peg$padEnd('', offsetS.line.toString().length, ' ');
      const line = src[s.line - 1];
      const last = s.line === e.line ? e.column : line.length + 1;
      const hatLen = last - s.column || 1;
      str += '\n --> ' + loc + '\n' + filler + ' |\n' + offsetS.line + ' | ' + line + '\n' + filler + ' | ' + peg$padEnd('', s.column - 1, ' ') + peg$padEnd('', hatLen, '^');
    } else {
      str += '\n at ' + loc;
    }
  }
  return str;
};
peg$SyntaxError.buildMessage = function (expected, found) {
  const DESCRIBE_EXPECTATION_FNS = {
    literal: function (expectation) {
      return '"' + literalEscape(expectation.text) + '"';
    },
    class: function (expectation) {
      const escapedParts = expectation.parts.map(function (part) {
        return Array.isArray(part) ? classEscape(part[0]) + '-' + classEscape(part[1]) : classEscape(part);
      });
      return '[' + (expectation.inverted ? '^' : '') + escapedParts.join('') + ']';
    },
    any: function () {
      return 'any character';
    },
    end: function () {
      return 'end of input';
    },
    other: function (expectation) {
      return expectation.description;
    }
  };
  function hex(ch) {
    return ch.charCodeAt(0).toString(16).toUpperCase();
  }
  function literalEscape(s) {
    return s.replace(/\\/g, '\\\\').replace(/"/g, '\\"').replace(/\0/g, '\\0').replace(/\t/g, '\\t').replace(/\n/g, '\\n').replace(/\r/g, '\\r').replace(/[\x00-\x0F]/g, function (ch) {
      return '\\x0' + hex(ch);
    }).replace(/[\x10-\x1F\x7F-\x9F]/g, function (ch) {
      return '\\x' + hex(ch);
    });
  }
  function classEscape(s) {
    return s.replace(/\\/g, '\\\\').replace(/\]/g, '\\]').replace(/\^/g, '\\^').replace(/-/g, '\\-').replace(/\0/g, '\\0').replace(/\t/g, '\\t').replace(/\n/g, '\\n').replace(/\r/g, '\\r').replace(/[\x00-\x0F]/g, function (ch) {
      return '\\x0' + hex(ch);
    }).replace(/[\x10-\x1F\x7F-\x9F]/g, function (ch) {
      return '\\x' + hex(ch);
    });
  }
  function describeExpectation(expectation) {
    return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
  }
  function describeExpected(expected) {
    const descriptions = expected.map(describeExpectation);
    let i;
    let j;
    descriptions.sort();
    if (descriptions.length > 0) {
      for (i = 1, j = 1; i < descriptions.length; i++) {
        if (descriptions[i - 1] !== descriptions[i]) {
          descriptions[j] = descriptions[i];
          j++;
        }
      }
      descriptions.length = j;
    }
    switch (descriptions.length) {
      case 1:
        return descriptions[0];
      case 2:
        return descriptions[0] + ' or ' + descriptions[1];
      default:
        return descriptions.slice(0, -1).join(', ') + ', or ' + descriptions[descriptions.length - 1];
    }
  }
  function describeFound(found) {
    return found ? '"' + literalEscape(found) + '"' : 'end of input';
  }
  return 'Expected ' + describeExpected(expected) + ' but ' + describeFound(found) + ' found.';
};
function peg$parse(input, options) {
  options = options !== undefined ? options : {};
  const peg$FAILED = {};
  const peg$source = options.grammarSource;
  const peg$startRuleFunctions = {
    Exps: peg$parseExps
  };
  let peg$startRuleFunction = peg$parseExps;
  const peg$c0 = '${';
  const peg$c1 = '}';
  const peg$c2 = ':';
  const peg$c3 = '\\';
  const peg$c4 = '$';
  const peg$r0 = /^[^}:\\\r\n]/;
  const peg$r1 = /^[^}\\\r\n]/;
  const peg$r2 = /^[^$]/;
  const peg$r3 = /^[^{]/;
  const peg$r4 = /^[ \t\n\r]/;
  const peg$e0 = peg$literalExpectation('${', false);
  const peg$e1 = peg$literalExpectation('}', false);
  const peg$e2 = peg$literalExpectation(':', false);
  const peg$e3 = peg$classExpectation(['}', ':', '\\', '\r', '\n'], true, false);
  const peg$e4 = peg$literalExpectation('\\', false);
  const peg$e5 = peg$classExpectation(['}', '\\', '\r', '\n'], true, false);
  const peg$e6 = peg$classExpectation(['$'], true, false);
  const peg$e7 = peg$literalExpectation('$', false);
  const peg$e8 = peg$classExpectation(['{'], true, false);
  const peg$e9 = peg$otherExpectation('whitespace');
  const peg$e10 = peg$classExpectation([' ', '\t', '\n', '\r'], false, false);
  const peg$f0 = function (e) {
    return e;
  };
  const peg$f1 = function (varCont) {
    return {
      type: 'var',
      content: {
        name: varCont[0][0].content,
        default: varCont[0][1] ? varCont[0][1].content : null
      }
    };
  };
  const peg$f2 = function (varCont) {
    return {
      type: 'varname',
      content: varCont.map(c => c.char || c).join('')
    };
  };
  const peg$f3 = function (defCont) {
    return {
      type: 'vardefault',
      content: defCont.join('')
    };
  };
  const peg$f4 = function () {
    return {
      type: 'char',
      char: '\\'
    };
  };
  const peg$f5 = function () {
    return {
      type: 'char',
      char: '\x7d'
    };
  };
  const peg$f6 = function (sequence) {
    return sequence.char;
  };
  const peg$f7 = function () {
    return {
      type: 'char',
      char: '\\'
    };
  };
  const peg$f8 = function () {
    return {
      type: 'char',
      char: '\x7d'
    };
  };
  const peg$f9 = function (sequence) {
    return sequence.char;
  };
  const peg$f10 = function (nonVarCont) {
    return {
      type: 'nonvar',
      content: nonVarCont.map(c => c.char || c).join('')
    };
  };
  let peg$currPos = options.peg$currPos | 0;
  // eslint-disable-next-line no-unused-vars
  let peg$savedPos = peg$currPos;
  const peg$posDetailsCache = [{
    line: 1,
    column: 1
  }];
  let peg$maxFailPos = peg$currPos;
  let peg$maxFailExpected = options.peg$maxFailExpected || [];
  let peg$silentFails = options.peg$silentFails | 0;
  let peg$result;
  if (options.startRule) {
    if (!(options.startRule in peg$startRuleFunctions)) {
      throw new Error('Can\'t start parsing from rule "' + options.startRule + '".');
    }
    peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
  }
  function peg$literalExpectation(text, ignoreCase) {
    return {
      type: 'literal',
      text: text,
      ignoreCase: ignoreCase
    };
  }
  function peg$classExpectation(parts, inverted, ignoreCase) {
    return {
      type: 'class',
      parts: parts,
      inverted: inverted,
      ignoreCase: ignoreCase
    };
  }
  function peg$endExpectation() {
    return {
      type: 'end'
    };
  }
  function peg$otherExpectation(description) {
    return {
      type: 'other',
      description: description
    };
  }
  function peg$computePosDetails(pos) {
    let details = peg$posDetailsCache[pos];
    let p;
    if (details) {
      return details;
    } else {
      if (pos >= peg$posDetailsCache.length) {
        p = peg$posDetailsCache.length - 1;
      } else {
        p = pos;
        while (!peg$posDetailsCache[--p]) {
          /* empty */
        }
      }
      details = peg$posDetailsCache[p];
      details = {
        line: details.line,
        column: details.column
      };
      while (p < pos) {
        if (input.charCodeAt(p) === 10) {
          details.line++;
          details.column = 1;
        } else {
          details.column++;
        }
        p++;
      }
      peg$posDetailsCache[pos] = details;
      return details;
    }
  }
  function peg$computeLocation(startPos, endPos, offset) {
    const startPosDetails = peg$computePosDetails(startPos);
    const endPosDetails = peg$computePosDetails(endPos);
    const res = {
      source: peg$source,
      start: {
        offset: startPos,
        line: startPosDetails.line,
        column: startPosDetails.column
      },
      end: {
        offset: endPos,
        line: endPosDetails.line,
        column: endPosDetails.column
      }
    };
    if (offset && peg$source && typeof peg$source.offset === 'function') {
      res.start = peg$source.offset(res.start);
      res.end = peg$source.offset(res.end);
    }
    return res;
  }
  function peg$fail(expected) {
    if (peg$currPos < peg$maxFailPos) {
      return;
    }
    if (peg$currPos > peg$maxFailPos) {
      peg$maxFailPos = peg$currPos;
      peg$maxFailExpected = [];
    }
    peg$maxFailExpected.push(expected);
  }
  function peg$buildStructuredError(expected, found, location) {
    // eslint-disable-next-line new-cap
    return new peg$SyntaxError(peg$SyntaxError.buildMessage(expected, found), expected, found, location);
  }
  function peg$parseExps() {
    let s0;
    let s1;
    let s2;
    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseExp();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseExp();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f0(s1);
    }
    s0 = s1;
    return s0;
  }
  function peg$parseExp() {
    let s0;
    s0 = peg$parseVar();
    if (s0 === peg$FAILED) {
      s0 = peg$parseNonVar();
    }
    return s0;
  }
  function peg$parseVar() {
    let s0;
    let s1;
    let s3;
    let s4;
    let s5;
    s0 = peg$currPos;
    if (input.substr(peg$currPos, 2) === peg$c0) {
      s1 = peg$c0;
      peg$currPos += 2;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e0);
      }
    }
    if (s1 !== peg$FAILED) {
      peg$parse_();
      s3 = [];
      s4 = peg$parseVarInner();
      if (s4 !== peg$FAILED) {
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$parseVarInner();
        }
      } else {
        s3 = peg$FAILED;
      }
      if (s3 !== peg$FAILED) {
        s4 = peg$parse_();
        if (input.charCodeAt(peg$currPos) === 125) {
          s5 = peg$c1;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e1);
          }
        }
        if (s5 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f1(s3);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    return s0;
  }
  function peg$parseVarInner() {
    let s0;
    let s1;
    let s2;
    s0 = peg$currPos;
    s1 = peg$parseVarName();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseVarDefault();
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      s1 = [s1, s2];
      s0 = s1;
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    return s0;
  }
  function peg$parseVarName() {
    let s0;
    let s1;
    let s2;
    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseVarNameChar();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseVarNameChar();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f2(s1);
    }
    s0 = s1;
    return s0;
  }
  function peg$parseVarDefault() {
    let s0;
    let s1;
    let s2;
    let s3;
    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 58) {
      s1 = peg$c2;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e2);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseVarDefaultChar();
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseVarDefaultChar();
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        peg$savedPos = s0;
        s0 = peg$f3(s2);
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    return s0;
  }
  function peg$parseVarNameChar() {
    let s0;
    let s1;
    let s2;
    let s3;
    s0 = input.charAt(peg$currPos);
    if (peg$r0.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e3);
      }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseEscape();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 92) {
          s3 = peg$c3;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e4);
          }
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s2;
          s3 = peg$f4();
        }
        s2 = s3;
        if (s2 === peg$FAILED) {
          s2 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 125) {
            s3 = peg$c1;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e1);
            }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s2;
            s3 = peg$f5();
          }
          s2 = s3;
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f6(s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }
    return s0;
  }
  function peg$parseVarDefaultChar() {
    let s0;
    let s1;
    let s2;
    let s3;
    s0 = input.charAt(peg$currPos);
    if (peg$r1.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e5);
      }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      s1 = peg$parseEscape();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 92) {
          s3 = peg$c3;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$e4);
          }
        }
        if (s3 !== peg$FAILED) {
          peg$savedPos = s2;
          s3 = peg$f7();
        }
        s2 = s3;
        if (s2 === peg$FAILED) {
          s2 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 125) {
            s3 = peg$c1;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e1);
            }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s2;
            s3 = peg$f8();
          }
          s2 = s3;
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s0 = peg$f9(s2);
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }
    return s0;
  }
  function peg$parseNonVar() {
    let s0;
    let s1;
    let s2;
    s0 = peg$currPos;
    s1 = [];
    s2 = peg$parseNonVarCont();
    if (s2 !== peg$FAILED) {
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseNonVarCont();
      }
    } else {
      s1 = peg$FAILED;
    }
    if (s1 !== peg$FAILED) {
      peg$savedPos = s0;
      s1 = peg$f10(s1);
    }
    s0 = s1;
    return s0;
  }
  function peg$parseNonVarCont() {
    let s0;
    s0 = peg$parseDollarNotVarStart();
    if (s0 === peg$FAILED) {
      s0 = peg$parseNotDollar();
    }
    return s0;
  }
  function peg$parseNotDollar() {
    let s0;
    s0 = input.charAt(peg$currPos);
    if (peg$r2.test(s0)) {
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e6);
      }
    }
    return s0;
  }
  function peg$parseDollarNotVarStart() {
    let s0;
    let s1;
    let s2;
    let s3;
    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 36) {
      s1 = peg$c4;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e7);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = input.charAt(peg$currPos);
      if (peg$r3.test(s3)) {
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e8);
        }
      }
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = input.charAt(peg$currPos);
          if (peg$r3.test(s3)) {
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$e8);
            }
          }
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    return s0;
  }
  function peg$parse_() {
    let s0;
    let s1;
    peg$silentFails++;
    // eslint-disable-next-line prefer-const
    s0 = [];
    s1 = input.charAt(peg$currPos);
    if (peg$r4.test(s1)) {
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e10);
      }
    }
    while (s1 !== peg$FAILED) {
      s0.push(s1);
      s1 = input.charAt(peg$currPos);
      if (peg$r4.test(s1)) {
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$e10);
        }
      }
    }
    peg$silentFails--;
    s1 = peg$FAILED;
    if (peg$silentFails === 0) {
      peg$fail(peg$e9);
    }
    return s0;
  }
  function peg$parseEscape() {
    let s0;
    if (input.charCodeAt(peg$currPos) === 92) {
      s0 = peg$c3;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$e4);
      }
    }
    return s0;
  }

  // eslint-disable-next-line prefer-const
  peg$result = peg$startRuleFunction();
  if (options.peg$library) {
    return /** @type {any} */{
      peg$result,
      peg$currPos,
      peg$FAILED,
      peg$maxFailExpected,
      peg$maxFailPos
    };
  }
  if (peg$result !== peg$FAILED && peg$currPos === input.length) {
    return peg$result;
  } else {
    if (peg$result !== peg$FAILED && peg$currPos < input.length) {
      peg$fail(peg$endExpectation());
    }
    throw peg$buildStructuredError(peg$maxFailExpected, peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null, peg$maxFailPos < input.length ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1) : peg$computeLocation(peg$maxFailPos, peg$maxFailPos));
  }
}
var _default = exports.default = {
  parse: peg$parse
};
/**
 Exps
 = e:Exp+ {
 return e;
 }

 Exp
 = Var / NonVar

 Var
 = "${" _ varCont:VarInner+ _ "}" {
 return { type: "var", content: {name: varCont[0][0].content, default: varCont[0][1] ? varCont[0][1].content : null} }
 }

 VarInner
 = VarName VarDefault?

 VarName
 = varCont:VarNameChar+ {
 return { type: "varname", content: varCont.map(c => c.char || c).join('') }
 }

 VarDefault
 = ":" defCont:VarDefaultChar+ {
 return { type: "vardefault", content: defCont.join('')}
 }

 VarNameChar
 = [^}:\\\r\n]
 / Escape
 sequence:(
 "\\" { return {type: "char", char: "\\"}; }
 / "}" { return {type: "char", char: "\x7d"}; }
 )
 { return sequence.char; }

 VarDefaultChar
 = [^}\\\r\n]
 / Escape
 sequence:(
 "\\" { return {type: "char", char: "\\"}; }
 / "}" { return {type: "char", char: "\x7d"}; }
 )
 { return sequence.char; }

 NonVar
 = nonVarCont:NonVarCont+ {
 return { type: "nonvar", content: nonVarCont.map(c => c.char || c).join('') }
 }

 NonVarCont
 = DollarNotVarStart / NotDollar

 NotDollar
 = [^$]

 DollarNotVarStart
 = "$" [^{]+

 _ "whitespace"
 = [ \t\n\r]*

 Escape
 = "\\"


 */
module.exports = exports.default;