"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stringToObjectFormatter = exports.objectFormatter = exports.arrayFormatter = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const arrayFormatter = (fields, key) => {
  var _ref;
  const value = (_ref = fields[key]) !== null && _ref !== void 0 ? _ref : [];
  return value.length ? value : null;
};
exports.arrayFormatter = arrayFormatter;
const objectFormatter = (fields, key) => {
  var _ref2;
  const value = (_ref2 = fields[key]) !== null && _ref2 !== void 0 ? _ref2 : {};
  return Object.keys(value).length ? value : null;
};
exports.objectFormatter = objectFormatter;
const stringToObjectFormatter = (fields, key) => {
  const value = fields[key];
  try {
    const obj = JSON.parse(value || '{}');
    return Object.keys(obj).length ? obj : undefined;
  } catch {
    return undefined;
  }
};
exports.stringToObjectFormatter = stringToObjectFormatter;