"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.throttlingFormatter = exports.browserFormatters = void 0;
var _monitor_defaults = require("../../../../common/constants/monitor_defaults");
var _common_formatters = require("./common_formatters");
var _formatting_utils = require("./formatting_utils");
var _tls_formatters = require("./tls_formatters");
var _runtime_types = require("../../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const throttlingFormatter = fields => {
  var _throttling$value, _throttling$value2, _throttling$value3;
  const throttling = fields[_runtime_types.ConfigKey.THROTTLING_CONFIG];
  if (!throttling || (throttling === null || throttling === void 0 ? void 0 : throttling.id) === 'no-throttling' || !(throttling !== null && throttling !== void 0 && throttling.value)) {
    return 'false';
  }
  return JSON.stringify({
    download: Number((throttling === null || throttling === void 0 ? void 0 : (_throttling$value = throttling.value) === null || _throttling$value === void 0 ? void 0 : _throttling$value.download) || _monitor_defaults.DEFAULT_THROTTLING_VALUE.download),
    upload: Number((throttling === null || throttling === void 0 ? void 0 : (_throttling$value2 = throttling.value) === null || _throttling$value2 === void 0 ? void 0 : _throttling$value2.upload) || _monitor_defaults.DEFAULT_THROTTLING_VALUE.upload),
    latency: Number((throttling === null || throttling === void 0 ? void 0 : (_throttling$value3 = throttling.value) === null || _throttling$value3 === void 0 ? void 0 : _throttling$value3.latency) || _monitor_defaults.DEFAULT_THROTTLING_VALUE)
  });
};
exports.throttlingFormatter = throttlingFormatter;
const browserFormatters = exports.browserFormatters = {
  [_runtime_types.ConfigKey.SOURCE_PROJECT_CONTENT]: null,
  [_runtime_types.ConfigKey.SCREENSHOTS]: null,
  [_runtime_types.ConfigKey.IGNORE_HTTPS_ERRORS]: null,
  [_runtime_types.ConfigKey.PLAYWRIGHT_OPTIONS]: null,
  [_runtime_types.ConfigKey.TEXT_ASSERTION]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.PORT]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.URLS]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.METADATA]: _formatting_utils.objectToJsonFormatter,
  [_runtime_types.ConfigKey.SOURCE_INLINE]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.SYNTHETICS_ARGS]: _formatting_utils.arrayToJsonFormatter,
  [_runtime_types.ConfigKey.JOURNEY_FILTERS_MATCH]: _formatting_utils.stringToJsonFormatter,
  [_runtime_types.ConfigKey.JOURNEY_FILTERS_TAGS]: _formatting_utils.arrayToJsonFormatter,
  [_runtime_types.ConfigKey.THROTTLING_CONFIG]: throttlingFormatter,
  ..._common_formatters.commonFormatters,
  ..._tls_formatters.tlsFormatters
};