"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateInteger = exports.fromSettingsAttribute = exports.createPostDynamicSettingsRoute = exports.createGetDynamicSettingsRoute = exports.VALUE_MUST_BE_AN_INTEGER = exports.DynamicSettingsSchema = void 0;
var _i18n = require("@kbn/i18n");
var _configSchema = require("@kbn/config-schema");
var _synthetics_settings = require("../../saved_objects/synthetics_settings");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createGetDynamicSettingsRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.DYNAMIC_SETTINGS,
  validate: false,
  handler: async ({
    savedObjectsClient
  }) => {
    const dynamicSettingsAttributes = await (0, _synthetics_settings.getSyntheticsDynamicSettings)(savedObjectsClient);
    return fromSettingsAttribute(dynamicSettingsAttributes);
  }
});
exports.createGetDynamicSettingsRoute = createGetDynamicSettingsRoute;
const createPostDynamicSettingsRoute = () => ({
  method: 'PUT',
  path: _constants.SYNTHETICS_API_URLS.DYNAMIC_SETTINGS,
  validate: {
    body: DynamicSettingsSchema
  },
  writeAccess: true,
  handler: async ({
    savedObjectsClient,
    request
  }) => {
    const newSettings = request.body;
    const prevSettings = await (0, _synthetics_settings.getSyntheticsDynamicSettings)(savedObjectsClient);
    const attr = await (0, _synthetics_settings.setSyntheticsDynamicSettings)(savedObjectsClient, {
      ...prevSettings,
      ...newSettings
    });
    return fromSettingsAttribute(attr);
  }
});
exports.createPostDynamicSettingsRoute = createPostDynamicSettingsRoute;
const fromSettingsAttribute = attr => {
  var _attr$defaultStatusRu, _attr$defaultTLSRuleE;
  return {
    certExpirationThreshold: attr.certExpirationThreshold,
    certAgeThreshold: attr.certAgeThreshold,
    defaultConnectors: attr.defaultConnectors,
    defaultEmail: attr.defaultEmail,
    defaultStatusRuleEnabled: (_attr$defaultStatusRu = attr.defaultStatusRuleEnabled) !== null && _attr$defaultStatusRu !== void 0 ? _attr$defaultStatusRu : true,
    defaultTLSRuleEnabled: (_attr$defaultTLSRuleE = attr.defaultTLSRuleEnabled) !== null && _attr$defaultTLSRuleE !== void 0 ? _attr$defaultTLSRuleE : true
  };
};
exports.fromSettingsAttribute = fromSettingsAttribute;
const VALUE_MUST_BE_AN_INTEGER = exports.VALUE_MUST_BE_AN_INTEGER = _i18n.i18n.translate('xpack.synthetics.settings.invalid.nanError', {
  defaultMessage: 'Value must be an integer.'
});
const validateInteger = value => {
  if (value % 1) {
    return VALUE_MUST_BE_AN_INTEGER;
  }
};
exports.validateInteger = validateInteger;
const DynamicSettingsSchema = exports.DynamicSettingsSchema = _configSchema.schema.object({
  certAgeThreshold: _configSchema.schema.maybe(_configSchema.schema.number({
    min: 1,
    validate: validateInteger
  })),
  certExpirationThreshold: _configSchema.schema.maybe(_configSchema.schema.number({
    min: 1,
    validate: validateInteger
  })),
  defaultConnectors: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  defaultStatusRuleEnabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  defaultTLSRuleEnabled: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  defaultEmail: _configSchema.schema.maybe(_configSchema.schema.object({
    to: _configSchema.schema.arrayOf(_configSchema.schema.string()),
    cc: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
    bcc: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
  }))
});