"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syntheticsGetLatestTestRunRoute = exports.getLatestTestRunRouteQuerySchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _get_latest_test_run = require("../../queries/get_latest_test_run");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLatestTestRunRouteQuerySchema = exports.getLatestTestRunRouteQuerySchema = _configSchema.schema.object({
  from: _configSchema.schema.maybe(_configSchema.schema.string()),
  to: _configSchema.schema.maybe(_configSchema.schema.string()),
  locationLabel: _configSchema.schema.maybe(_configSchema.schema.string()),
  monitorId: _configSchema.schema.string()
});
const syntheticsGetLatestTestRunRoute = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.LATEST_TEST_RUN,
  validate: {},
  validation: {
    request: {
      query: getLatestTestRunRouteQuerySchema
    }
  },
  handler: async ({
    syntheticsEsClient,
    request,
    response
  }) => {
    const {
      from,
      to,
      monitorId,
      locationLabel
    } = request.query;
    const getPing = fromVal => {
      return (0, _get_latest_test_run.getLatestTestRun)({
        syntheticsEsClient,
        from: fromVal,
        to: to || 'now',
        monitorId,
        locationLabel
      });
    };

    // we will try to get the latest ping from the last day,
    // if it doesn't exist we will try to get the latest ping from the last week
    const ping = await getPing(from || 'now-1d');

    // if from is provided, we will only try to get the latest ping from the provided time range
    if (ping && from) {
      return {
        ping
      };
    }
    // fall back to 1w and then max 30 days
    return {
      ping: (await getPing('now-1w')) || (await getPing('now-30d'))
    };
  }
});
exports.syntheticsGetLatestTestRunRoute = syntheticsGetLatestTestRunRoute;