"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseMonitorLocations = exports.getPrivateLocationsForMonitor = void 0;
var _get_private_locations = require("../../../synthetics_service/get_private_locations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPrivateLocationsForMonitor = async (soClient, normalizedMonitor) => {
  const {
    locations
  } = normalizedMonitor;
  const hasPrivateLocation = locations.filter(location => !location.isServiceManaged);
  if (hasPrivateLocation.length === 0) {
    return [];
  }
  return await (0, _get_private_locations.getPrivateLocations)(soClient);
};
exports.getPrivateLocationsForMonitor = getPrivateLocationsForMonitor;
const parseMonitorLocations = (monitorPayload, prevLocations, internal = false) => {
  var _locations$filter, _ref;
  const {
    locations,
    private_locations: privateLocations
  } = monitorPayload;
  let locs = locations === null || locations === void 0 ? void 0 : locations.filter(loc => typeof loc === 'string' || loc.isServiceManaged).map(loc => typeof loc === 'string' ? loc : loc.id);
  const extractPvtLocs = (_locations$filter = locations === null || locations === void 0 ? void 0 : locations.filter(loc => typeof loc !== 'string' && !loc.isServiceManaged)) !== null && _locations$filter !== void 0 ? _locations$filter : [];
  let pvtLocs = (_ref = [...(privateLocations !== null && privateLocations !== void 0 ? privateLocations : []), ...extractPvtLocs]) === null || _ref === void 0 ? void 0 : _ref.map(loc => typeof loc === 'string' ? loc : loc.id);
  if (internal && !privateLocations && !locations && prevLocations) {
    locs = prevLocations.filter(loc => loc.isServiceManaged).map(loc => loc.id);
    pvtLocs = prevLocations.filter(loc => !loc.isServiceManaged).map(loc => loc.id);
  } else {
    if (prevLocations && !internal) {
      const prevPublicLocs = prevLocations.filter(loc => loc.isServiceManaged).map(loc => loc.id);
      const prevPrivateLocs = prevLocations.filter(loc => !loc.isServiceManaged).map(loc => loc.id);
      if (!locations && !privateLocations) {
        locs = prevPublicLocs;
        pvtLocs = prevPrivateLocs;
      } else {
        if (!privateLocations) {
          var _pvtLocs;
          pvtLocs = [...((_pvtLocs = pvtLocs) !== null && _pvtLocs !== void 0 ? _pvtLocs : []), ...prevPrivateLocs];
          if ((locations === null || locations === void 0 ? void 0 : locations.length) === 0) {
            locs = [];
          }
        }
        if (!locations) {
          var _locs;
          locs = [...((_locs = locs) !== null && _locs !== void 0 ? _locs : []), ...prevPublicLocs];
          if ((privateLocations === null || privateLocations === void 0 ? void 0 : privateLocations.length) === 0) {
            pvtLocs = [];
          }
        }
      }
    }
  }
  return {
    locations: Array.from(new Set(locs)),
    privateLocations: Array.from(new Set(pvtLocs))
  };
};
exports.parseMonitorLocations = parseMonitorLocations;