"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSyntheticsFilters = void 0;
var _configSchema = require("@kbn/config-schema");
var _saved_objects = require("../../../common/types/saved_objects");
var _runtime_types = require("../../../common/runtime_types");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mergeBuckets = (...bucketSets) => {
  const map = new Map();
  for (const buckets of bucketSets) {
    buckets === null || buckets === void 0 ? void 0 : buckets.forEach(({
      key,
      doc_count: docCount
    }) => {
      var _map$get;
      const k = String(key);
      map.set(k, ((_map$get = map.get(k)) !== null && _map$get !== void 0 ? _map$get : 0) + docCount);
    });
  }
  return Array.from(map.entries()).map(([label, count]) => ({
    label,
    count
  }));
};
const getSyntheticsFilters = () => ({
  method: 'GET',
  path: _constants.SYNTHETICS_API_URLS.FILTERS,
  validate: {
    query: _configSchema.schema.object({
      showFromAllSpaces: _configSchema.schema.maybe(_configSchema.schema.boolean())
    })
  },
  handler: async ({
    savedObjectsClient,
    request
  }) => {
    var _request$query, _ref;
    const showFromAllSpaces = (_request$query = request.query) === null || _request$query === void 0 ? void 0 : _request$query.showFromAllSpaces;
    const data = await savedObjectsClient.find({
      type: [_saved_objects.legacySyntheticsMonitorTypeSingle, _saved_objects.syntheticsMonitorSavedObjectType],
      perPage: 0,
      aggs,
      ...(showFromAllSpaces ? {
        namespaces: ['*']
      } : {})
    });
    const {
      monitorTypes,
      monitorTypesLegacy,
      tags,
      tagsLegacy,
      locations,
      locationsLegacy,
      projects,
      projectsLegacy,
      schedules,
      schedulesLegacy
    } = (_ref = data === null || data === void 0 ? void 0 : data.aggregations) !== null && _ref !== void 0 ? _ref : {};
    return {
      monitorTypes: mergeBuckets(monitorTypes === null || monitorTypes === void 0 ? void 0 : monitorTypes.buckets, monitorTypesLegacy === null || monitorTypesLegacy === void 0 ? void 0 : monitorTypesLegacy.buckets),
      tags: mergeBuckets(tags === null || tags === void 0 ? void 0 : tags.buckets, tagsLegacy === null || tagsLegacy === void 0 ? void 0 : tagsLegacy.buckets),
      locations: mergeBuckets(locations === null || locations === void 0 ? void 0 : locations.buckets, locationsLegacy === null || locationsLegacy === void 0 ? void 0 : locationsLegacy.buckets),
      projects: mergeBuckets(projects === null || projects === void 0 ? void 0 : projects.buckets, projectsLegacy === null || projectsLegacy === void 0 ? void 0 : projectsLegacy.buckets).filter(({
        label
      }) => label),
      schedules: mergeBuckets(schedules === null || schedules === void 0 ? void 0 : schedules.buckets, schedulesLegacy === null || schedulesLegacy === void 0 ? void 0 : schedulesLegacy.buckets).map(({
        label,
        count
      }) => ({
        label: String(label),
        count
      }))
    };
  }
});
exports.getSyntheticsFilters = getSyntheticsFilters;
const aggs = {
  monitorTypes: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorAttributes}.${_runtime_types.ConfigKey.MONITOR_TYPE}.keyword`,
      size: 10000
    }
  },
  monitorTypesLegacy: {
    terms: {
      field: `${_saved_objects.legacyMonitorAttributes}.${_runtime_types.ConfigKey.MONITOR_TYPE}.keyword`,
      size: 10000
    }
  },
  tags: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorAttributes}.${_runtime_types.ConfigKey.TAGS}`,
      size: 10000
    }
  },
  tagsLegacy: {
    terms: {
      field: `${_saved_objects.legacyMonitorAttributes}.${_runtime_types.ConfigKey.TAGS}`,
      size: 10000
    }
  },
  locations: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorAttributes}.${_runtime_types.ConfigKey.LOCATIONS}.id`,
      size: 10000
    }
  },
  locationsLegacy: {
    terms: {
      field: `${_saved_objects.legacyMonitorAttributes}.${_runtime_types.ConfigKey.LOCATIONS}.id`,
      size: 10000
    }
  },
  projects: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorAttributes}.${_runtime_types.ConfigKey.PROJECT_ID}`,
      size: 10000
    }
  },
  projectsLegacy: {
    terms: {
      field: `${_saved_objects.legacyMonitorAttributes}.${_runtime_types.ConfigKey.PROJECT_ID}`,
      size: 10000
    }
  },
  schedules: {
    terms: {
      field: `${_saved_objects.syntheticsMonitorAttributes}.${_runtime_types.ConfigKey.SCHEDULE}.number`,
      size: 10000
    }
  },
  schedulesLegacy: {
    terms: {
      field: `${_saved_objects.legacyMonitorAttributes}.${_runtime_types.ConfigKey.SCHEDULE}.number`,
      size: 10000
    }
  }
};