"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.syntheticsFeature = exports.PRIVATE_LOCATION_WRITE_API = void 0;
var _server = require("@kbn/core/server");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/alerting-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _private_locations = require("../common/saved_objects/private_locations");
var _saved_objects = require("../common/types/saved_objects");
var _plugin = require("../common/constants/plugin");
var _synthetics_settings = require("./saved_objects/synthetics_settings");
var _service_api_key = require("./saved_objects/service_api_key");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PRIVATE_LOCATION_WRITE_API = exports.PRIVATE_LOCATION_WRITE_API = 'private-location-write';
const ruleTypes = [..._ruleDataUtils.UPTIME_RULE_TYPE_IDS, ..._ruleDataUtils.SYNTHETICS_RULE_TYPE_IDS];
const alertingFeatures = ruleTypes.map(ruleTypeId => ({
  ruleTypeId,
  consumers: [_plugin.PLUGIN.ID, _common.ALERTING_FEATURE_ID, ..._ruleDataUtils.DEPRECATED_ALERTING_CONSUMERS]
}));
const elasticManagedLocationsEnabledPrivilege = {
  groupType: 'independent',
  privileges: [{
    id: 'elastic_managed_locations_enabled',
    name: _i18n.i18n.translate('xpack.synthetics.features.elasticManagedLocations.label', {
      defaultMessage: 'Enabled'
    }),
    includeIn: 'all',
    savedObject: {
      all: [],
      read: []
    },
    ui: ['elasticManagedLocationsEnabled']
  }]
};
const canManagePrivateLocationsPrivilege = {
  groupType: 'independent',
  privileges: [{
    id: 'can_manage_private_locations',
    name: _i18n.i18n.translate('xpack.synthetics.features.canManagePrivateLocations', {
      defaultMessage: 'Can manage'
    }),
    includeIn: 'all',
    api: [PRIVATE_LOCATION_WRITE_API],
    savedObject: {
      all: [_private_locations.privateLocationSavedObjectName, _private_locations.legacyPrivateLocationsSavedObjectName],
      read: []
    },
    ui: ['canManagePrivateLocations']
  }]
};
const syntheticsFeature = exports.syntheticsFeature = {
  id: _plugin.PLUGIN.ID,
  name: _plugin.PLUGIN.NAME,
  order: 1000,
  category: _server.DEFAULT_APP_CATEGORIES.observability,
  app: ['uptime', 'kibana', 'synthetics'],
  catalogue: ['uptime'],
  management: {
    insightsAndAlerting: ['triggersActions']
  },
  alerting: alertingFeatures,
  privileges: {
    all: {
      app: ['uptime', 'kibana', 'synthetics'],
      catalogue: ['uptime'],
      api: ['uptime-read', 'uptime-write', 'lists-all', 'rac'],
      savedObject: {
        all: [_synthetics_settings.syntheticsSettingsObjectType, _saved_objects.legacySyntheticsMonitorTypeSingle, _saved_objects.syntheticsMonitorSavedObjectType, _service_api_key.syntheticsApiKeyObjectType, _saved_objects.syntheticsParamType,
        // uptime settings object is also registered here since feature is shared between synthetics and uptime
        _synthetics_settings.uptimeSettingsObjectType],
        read: [_private_locations.privateLocationSavedObjectName, _private_locations.legacyPrivateLocationsSavedObjectName]
      },
      alerting: {
        rule: {
          all: alertingFeatures
        },
        alert: {
          all: alertingFeatures
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['save', 'configureSettings', 'show', 'alerting:save']
    },
    read: {
      app: ['uptime', 'kibana', 'synthetics'],
      catalogue: ['uptime'],
      api: ['uptime-read', 'lists-read', 'rac'],
      savedObject: {
        all: [],
        read: [_saved_objects.syntheticsParamType, _synthetics_settings.syntheticsSettingsObjectType, _saved_objects.syntheticsMonitorSavedObjectType, _saved_objects.legacySyntheticsMonitorTypeSingle, _service_api_key.syntheticsApiKeyObjectType, _private_locations.privateLocationSavedObjectName, _private_locations.legacyPrivateLocationsSavedObjectName,
        // uptime settings object is also registered here since feature is shared between synthetics and uptime
        _synthetics_settings.uptimeSettingsObjectType]
      },
      alerting: {
        rule: {
          read: alertingFeatures
        },
        alert: {
          read: alertingFeatures
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show', 'alerting:save']
    }
  },
  subFeatures: [{
    name: _i18n.i18n.translate('xpack.synthetics.features.app.elastic', {
      defaultMessage: 'Elastic managed locations'
    }),
    description: _i18n.i18n.translate('xpack.synthetics.features.app.elasticDescription', {
      defaultMessage: 'This feature enables users to create monitors that execute tests from Elastic managed infrastructure around the globe. There is an additional charge to use Elastic Managed testing locations. See the Elastic Cloud Pricing https://www.elastic.co/pricing page for current prices.'
    }),
    privilegeGroups: [elasticManagedLocationsEnabledPrivilege]
  }, {
    name: _i18n.i18n.translate('xpack.synthetics.features.app.private', {
      defaultMessage: 'Private locations'
    }),
    description: _i18n.i18n.translate('xpack.synthetics.features.app.private,description', {
      defaultMessage: 'This feature allows you to manage your private locations, for example adding, or deleting them.'
    }),
    privilegeGroups: [canManagePrivateLocationsPrivilege]
  }]
};