"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortPings = sortPings;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function sortPings(pings, sortField, sortDirection) {
  const toSort = [...pings];
  toSort.sort((a, b) => {
    var _getProp, _getProp2;
    let propA = (_getProp = (0, _lodash.get)(a, sortField)) !== null && _getProp !== void 0 ? _getProp : null;
    let propB = (_getProp2 = (0, _lodash.get)(b, sortField)) !== null && _getProp2 !== void 0 ? _getProp2 : null;
    if (propA === null || propB === null) {
      return 0;
    }
    if (sortField === 'timestamp') {
      propA = new Date(propA);
      propB = new Date(propB);
    }
    if (sortField === 'monitor.status') {
      propA = propA === 'up' ? -1 : 1;
      propB = propB === 'up' ? -1 : 1;
    }
    if (typeof propA === 'string') {
      return sortDirection === 'asc' ? propA.localeCompare(propB) : propB.localeCompare(propA);
    }
    return sortDirection === 'asc' ? propA - propB : propB - propA;
  });
  return toSort;
}