"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockDataPlugin = mockDataPlugin;
exports.mockDate = mockDate;
exports.mockDispatch = mockDispatch;
exports.mockMoment = mockMoment;
exports.mockMomentTimezone = mockMomentTimezone;
exports.mockReactRouterDomHooks = mockReactRouterDomHooks;
exports.mockReduxHooks = mockReduxHooks;
var _moment = _interopRequireDefault(require("moment"));
var redux = _interopRequireWildcard(require("react-redux"));
var reactRouterDom = _interopRequireWildcard(require("react-router-dom"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line no-restricted-imports

function mockMoment() {
  // avoid timezone issues
  jest.spyOn(_moment.default.prototype, 'format').mockImplementation(function () {
    return `Sept 4, 2020  9:31:38 AM`;
  });

  // convert relative time to absolute time to avoid timing issues
  jest.spyOn(_moment.default.prototype, 'fromNow').mockImplementation(function () {
    return `15 minutes ago`;
  });

  // use static locale string to avoid issues
  jest.spyOn(_moment.default.prototype, 'toLocaleString').mockImplementation(function () {
    return `Thu May 09 2019 10:15:11 GMT-0400`;
  });
}
function mockMomentTimezone() {
  jest.mock('moment-timezone', () => {
    return function () {
      return {
        tz: {
          guess: () => 'America/New_York'
        }
      };
    };
  });
}
function mockDate() {
  // use static date string to avoid CI timing issues
  jest.spyOn(Date.prototype, 'toString').mockImplementation(function () {
    return `Tue, 01 Jan 2019 00:00:00 GMT`;
  });
}
function mockDataPlugin() {
  jest.mock('@kbn/data-plugin/public', () => {
    return function () {
      return {
        esKuery: {
          fromKueryExpression: () => 'an ast',
          toElasticsearchQuery: () => 'an es query'
        }
      };
    };
  });
}
function mockReduxHooks(response) {
  jest.spyOn(redux, 'useDispatch').mockReturnValue(jest.fn());
  jest.spyOn(redux, 'useSelector').mockReturnValue(response);
}
function mockDispatch() {
  jest.spyOn(redux, 'useDispatch').mockReturnValue(jest.fn());
}
function mockReactRouterDomHooks({
  useParamsResponse
}) {
  jest.spyOn(reactRouterDom, 'useParams').mockReturnValue(useParamsResponse);
}