"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchMonitorStatusHeatmap = void 0;
var _constants = require("../../../../../common/constants");
var _api_service = require("../../../../utils/api_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchMonitorStatusHeatmap = async ({
  monitorId,
  location,
  from,
  to,
  interval
}) => {
  const response = await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.MONITOR_STATUS_HEATMAP, {
    monitorId,
    location,
    from,
    to,
    interval
  });
  return response.result;
};
exports.fetchMonitorStatusHeatmap = fetchMonitorStatusHeatmap;