"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setDynamicSettings = exports.getDynamicSettings = exports.fetchLocationMonitors = exports.fetchConnectors = exports.fetchActionTypes = void 0;
var _api_service = require("../../../../utils/api_service");
var _runtime_types = require("../../../../../common/runtime_types");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDynamicSettings = async () => {
  return await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.DYNAMIC_SETTINGS, {
    version: '2023-10-31'
  }, _runtime_types.DynamicSettingsCodec);
};
exports.getDynamicSettings = getDynamicSettings;
const setDynamicSettings = async ({
  settings
}) => {
  const newSettings = {
    certAgeThreshold: settings.certAgeThreshold,
    certExpirationThreshold: settings.certExpirationThreshold,
    defaultConnectors: settings.defaultConnectors,
    defaultEmail: settings.defaultEmail,
    defaultTLSRuleEnabled: settings.defaultTLSRuleEnabled,
    defaultStatusRuleEnabled: settings.defaultStatusRuleEnabled
  };
  return await _api_service.apiService.put(_constants.SYNTHETICS_API_URLS.DYNAMIC_SETTINGS, newSettings, _runtime_types.DynamicSettingsSaveCodec, {
    version: '2023-10-31'
  });
};
exports.setDynamicSettings = setDynamicSettings;
const fetchLocationMonitors = async () => {
  return await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.PRIVATE_LOCATIONS_MONITORS, undefined, _runtime_types.LocationMonitorsType);
};
exports.fetchLocationMonitors = fetchLocationMonitors;
const fetchConnectors = async () => {
  return await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.GET_ACTIONS_CONNECTORS);
};
exports.fetchConnectors = fetchConnectors;
const fetchActionTypes = async () => {
  return await _api_service.apiService.get(_constants.SYNTHETICS_API_URLS.GET_CONNECTOR_TYPES, {
    feature_id: 'uptime'
  });
};
exports.fetchActionTypes = fetchActionTypes;