"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyntheticsSettingsContext = exports.SyntheticsSettingsContextProvider = exports.SyntheticsSettingsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../common/constants");
var _hooks = require("../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/contexts/synthetics_settings_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  BASE_PATH
} = _constants.CONTEXT_DEFAULTS;
const {
  DATE_RANGE_START,
  DATE_RANGE_END
} = _constants.CLIENT_DEFAULTS;

/**
 * These are default values for the context. These defaults are typically
 * overwritten by the Synthetics App upon its invocation.
 */
const defaultContext = {
  basePath: BASE_PATH,
  dateRangeStart: DATE_RANGE_START,
  dateRangeEnd: DATE_RANGE_END,
  isApmAvailable: true,
  isInfraAvailable: true,
  isLogsAvailable: true,
  isDev: false,
  canSave: false,
  canManagePrivateLocations: false,
  darkMode: false
};
const SyntheticsSettingsContext = exports.SyntheticsSettingsContext = /*#__PURE__*/(0, _react.createContext)(defaultContext);
const SyntheticsSettingsContextProvider = ({
  children,
  ...props
}) => {
  var _application$capabili, _application$capabili2;
  const {
    basePath,
    isApmAvailable,
    isInfraAvailable,
    isLogsAvailable,
    commonlyUsedRanges,
    isDev,
    isServerless,
    darkMode
  } = props;
  const {
    dateRangeStart,
    dateRangeEnd
  } = (0, _hooks.useGetUrlParams)();
  const {
    application
  } = (0, _public.useKibana)().services;
  const canSave = (_application$capabili = application === null || application === void 0 ? void 0 : application.capabilities.uptime.save) !== null && _application$capabili !== void 0 ? _application$capabili : false;
  const canManagePrivateLocations = (_application$capabili2 = application === null || application === void 0 ? void 0 : application.capabilities.uptime.canManagePrivateLocations) !== null && _application$capabili2 !== void 0 ? _application$capabili2 : false;
  const value = (0, _react.useMemo)(() => {
    return {
      darkMode,
      canSave,
      isDev,
      basePath,
      isApmAvailable,
      isInfraAvailable,
      isLogsAvailable,
      commonlyUsedRanges,
      dateRangeStart: dateRangeStart !== null && dateRangeStart !== void 0 ? dateRangeStart : DATE_RANGE_START,
      dateRangeEnd: dateRangeEnd !== null && dateRangeEnd !== void 0 ? dateRangeEnd : DATE_RANGE_END,
      isServerless,
      canManagePrivateLocations
    };
  }, [darkMode, canSave, isDev, basePath, isApmAvailable, isInfraAvailable, isLogsAvailable, dateRangeStart, dateRangeEnd, commonlyUsedRanges, isServerless, canManagePrivateLocations]);
  return /*#__PURE__*/_react.default.createElement(SyntheticsSettingsContext.Provider, {
    value: value,
    children: children,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 10
    }
  });
};
exports.SyntheticsSettingsContextProvider = SyntheticsSettingsContextProvider;
const useSyntheticsSettingsContext = () => (0, _react.useContext)(SyntheticsSettingsContext);
exports.useSyntheticsSettingsContext = useSyntheticsSettingsContext;