"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSyntheticsRefreshContext = exports.SyntheticsRefreshContextProvider = exports.SyntheticsRefreshContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _useEvent = _interopRequireDefault(require("react-use/lib/useEvent"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _client_defaults = require("../../../../common/constants/synthetics/client_defaults");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/contexts/synthetics_refresh_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  AUTOREFRESH_INTERVAL_SECONDS,
  AUTOREFRESH_IS_PAUSED
} = _client_defaults.CLIENT_DEFAULTS_SYNTHETICS;
const defaultContext = {
  lastRefresh: 0,
  refreshApp: () => {
    throw new Error('App refresh was not initialized, set it when you invoke the context');
  },
  refreshInterval: AUTOREFRESH_INTERVAL_SECONDS,
  refreshPaused: AUTOREFRESH_IS_PAUSED,
  setRefreshInterval: () => {
    throw new Error(_i18n.i18n.translate('xpack.synthetics.refreshContext.intervalNotInitialized', {
      defaultMessage: 'Refresh interval was not initialized, set it when you invoke the context'
    }));
  },
  setRefreshPaused: () => {
    throw new Error(_i18n.i18n.translate('xpack.synthetics.refreshContext.pausedNotInitialized', {
      defaultMessage: 'Refresh paused was not initialized, set it when you invoke the context'
    }));
  }
};
const SyntheticsRefreshContext = exports.SyntheticsRefreshContext = /*#__PURE__*/(0, _react.createContext)(defaultContext);
const SyntheticsRefreshContextProvider = ({
  children,
  reload$
}) => {
  const [lastRefresh, setLastRefresh] = (0, _react.useState)(Date.now());
  const [refreshInterval, setRefreshInterval] = (0, _useLocalStorage.default)('xpack.synthetics.refreshInterval', AUTOREFRESH_INTERVAL_SECONDS);
  const [refreshPaused, setRefreshPaused] = (0, _useLocalStorage.default)('xpack.synthetics.refreshPaused', AUTOREFRESH_IS_PAUSED);
  const refreshApp = (0, _react.useCallback)(() => {
    const refreshTime = Date.now();
    setLastRefresh(refreshTime);
  }, [setLastRefresh]);
  (0, _react.useEffect)(() => {
    if (!refreshPaused) {
      refreshApp();
    }
  }, [refreshApp, refreshPaused]);
  (0, _react.useEffect)(() => {
    const subscription = reload$ === null || reload$ === void 0 ? void 0 : reload$.subscribe(() => {
      refreshApp();
    });
    return () => subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
  }, [reload$, refreshApp]);
  const value = (0, _react.useMemo)(() => {
    return {
      lastRefresh,
      refreshApp,
      refreshInterval: refreshInterval !== null && refreshInterval !== void 0 ? refreshInterval : AUTOREFRESH_INTERVAL_SECONDS,
      refreshPaused: refreshPaused !== null && refreshPaused !== void 0 ? refreshPaused : AUTOREFRESH_IS_PAUSED,
      setRefreshInterval,
      setRefreshPaused
    };
  }, [lastRefresh, refreshApp, refreshInterval, refreshPaused, setRefreshInterval, setRefreshPaused]);
  (0, _useEvent.default)('visibilitychange', () => {
    const isOutdated = (0, _moment.default)().diff(new Date(lastRefresh), 'seconds') > (refreshInterval || AUTOREFRESH_INTERVAL_SECONDS);
    if (document.visibilityState !== 'hidden' && !refreshPaused && isOutdated) {
      refreshApp();
    }
  }, document);
  (0, _react.useEffect)(() => {
    if (refreshPaused) {
      return;
    }
    const interval = setInterval(() => {
      if (document.visibilityState !== 'hidden') {
        refreshApp();
      }
    }, (refreshInterval || AUTOREFRESH_INTERVAL_SECONDS) * 1000);
    return () => clearInterval(interval);
  }, [refreshPaused, refreshApp, refreshInterval]);
  return /*#__PURE__*/_react.default.createElement(SyntheticsRefreshContext.Provider, {
    value: value,
    children: children,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 10
    }
  });
};
exports.SyntheticsRefreshContextProvider = SyntheticsRefreshContextProvider;
const useSyntheticsRefreshContext = () => (0, _react.useContext)(SyntheticsRefreshContext);
exports.useSyntheticsRefreshContext = useSyntheticsRefreshContext;