"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestRunSteps = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _test_time_formats = require("../../utils/monitor_test_result/test_time_formats");
var _browser_steps_list = require("../common/monitor_test_result/browser_steps_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_run_details/test_run_steps.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TestRunSteps = ({
  isLoading,
  steps
}) => {
  const totalDuration = steps.filter(_browser_steps_list.isStepEnd).reduce((acc, step) => {
    var _step$synthetics$step, _step$synthetics, _step$synthetics$step2;
    return acc + ((_step$synthetics$step = (_step$synthetics = step.synthetics) === null || _step$synthetics === void 0 ? void 0 : (_step$synthetics$step2 = _step$synthetics.step) === null || _step$synthetics$step2 === void 0 ? void 0 : _step$synthetics$step2.duration.us) !== null && _step$synthetics$step !== void 0 ? _step$synthetics$step : 0);
  }, 0);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 13
    }
  }, STEPS_EXECUTED))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }, TOTAL_DURATION, (0, _test_time_formats.formatTestDuration)(totalDuration))), /*#__PURE__*/_react.default.createElement(_browser_steps_list.BrowserStepsList, {
    steps: steps,
    loading: isLoading,
    showStepNumber: true,
    compressed: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }));
};
exports.TestRunSteps = TestRunSteps;
const STEPS_EXECUTED = _i18n.i18n.translate('xpack.synthetics.testDetails.stepExecuted', {
  defaultMessage: 'Steps executed'
});
const TOTAL_DURATION = _i18n.i18n.translate('xpack.synthetics.testDetails.totalDuration', {
  defaultMessage: 'Total duration: '
});