"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestRunErrorInfo = void 0;
var _eui = require("@elastic/eui");
var React = _interopRequireWildcard(require("react"));
var _stderr_logs = require("../../common/components/stderr_logs");
var _browser_test_results = require("../../test_now_mode/browser/browser_test_results");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_run_details/components/test_run_error_info.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TestRunErrorInfo = ({
  journeyDetails,
  hasNoSteps,
  showErrorTitle = true,
  showErrorLogs = false
}) => {
  var _journeyDetails$journ, _journeyDetails$journ2, _journeyDetails$journ3, _journeyDetails$journ4, _journeyDetails$journ5;
  const isDownMonitor = (journeyDetails === null || journeyDetails === void 0 ? void 0 : (_journeyDetails$journ = journeyDetails.journey) === null || _journeyDetails$journ === void 0 ? void 0 : (_journeyDetails$journ2 = _journeyDetails$journ.monitor) === null || _journeyDetails$journ2 === void 0 ? void 0 : _journeyDetails$journ2.status) === 'down';
  const errorMessage = journeyDetails === null || journeyDetails === void 0 ? void 0 : (_journeyDetails$journ3 = journeyDetails.journey) === null || _journeyDetails$journ3 === void 0 ? void 0 : (_journeyDetails$journ4 = _journeyDetails$journ3.error) === null || _journeyDetails$journ4 === void 0 ? void 0 : _journeyDetails$journ4.message;
  return /*#__PURE__*/React.createElement(React.Fragment, null, (hasNoSteps || isDownMonitor) && showErrorTitle && /*#__PURE__*/React.createElement(_eui.EuiCallOut, {
    "data-test-subj": "monitorTestRunErrorCallout",
    title: _browser_test_results.ERROR_RUNNING_TEST,
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, /*#__PURE__*/React.createElement(_eui.EuiText, {
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }, errorMessage !== null && errorMessage !== void 0 ? errorMessage : _browser_test_results.FAILED_TO_RUN)), /*#__PURE__*/React.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }), (showErrorLogs || hasNoSteps) && /*#__PURE__*/React.createElement(_stderr_logs.StdErrorLogs, {
    checkGroup: journeyDetails === null || journeyDetails === void 0 ? void 0 : (_journeyDetails$journ5 = journeyDetails.journey) === null || _journeyDetails$journ5 === void 0 ? void 0 : _journeyDetails$journ5.monitor.check_group,
    hideTitle: false,
    pageSize: 10,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }));
};
exports.TestRunErrorInfo = TestRunErrorInfo;