"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleTestResults = SimpleTestResults;
var _react = _interopRequireWildcard(require("react"));
var _use_simple_run_once_monitors = require("../hooks/use_simple_run_once_monitors");
var _test_result_header = require("../test_result_header");
var _ping_list_table = require("./ping_list/ping_list_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/test_now_mode/simple/simple_test_results.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SimpleTestResults({
  testRunId,
  expectPings,
  onDone
}) {
  const [summaryDocsCache, setSummaryDocsCache] = (0, _react.useState)([]);
  const {
    summaryDocs,
    loading
  } = (0, _use_simple_run_once_monitors.useSimpleRunOnceMonitors)({
    testRunId,
    expectSummaryDocs: expectPings
  });
  (0, _react.useEffect)(() => {
    if (summaryDocs) {
      setSummaryDocsCache(prevState => {
        const prevById = prevState.reduce((acc, cur) => ({
          ...acc,
          [cur.docId]: cur
        }), {});
        return summaryDocs.map(updatedDoc => {
          var _prevById;
          return {
            ...updatedDoc,
            ...((_prevById = prevById[updatedDoc.docId]) !== null && _prevById !== void 0 ? _prevById : {})
          };
        });
      });
      if (summaryDocs.length >= expectPings) {
        onDone(testRunId);
      }
    }
  }, [testRunId, expectPings, summaryDocs, onDone]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_test_result_header.TestResultHeader, {
    summaryDocs: summaryDocsCache,
    isCompleted: Boolean(summaryDocs && summaryDocs.length >= expectPings),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }), summaryDocs && /*#__PURE__*/_react.default.createElement(_ping_list_table.PingListTable, {
    pings: summaryDocsCache,
    loading: loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 23
    }
  }));
}