"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSimpleRunOnceMonitors = void 0;
var _react = require("react");
var _public = require("@kbn/observability-shared-plugin/public");
var _client_defaults = require("../../../../../../common/constants/client_defaults");
var _constants = require("../../../../../../common/constants");
var _use_tick_tick = require("./use_tick_tick");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_RETRIES = 50;
const useSimpleRunOnceMonitors = ({
  expectSummaryDocs,
  testRunId
}) => {
  const {
    refreshTimer,
    lastRefresh
  } = (0, _use_tick_tick.useTickTick)(2 * 1000);
  const [numberOfRetries, setNumberOfRetries] = (0, _react.useState)(0);
  const {
    data,
    loading
  } = (0, _public.useEsSearch)((0, _public.createEsParams)({
    index: _constants.SYNTHETICS_INDEX_PATTERN,
    sort: [{
      '@timestamp': 'desc'
    }],
    query: {
      bool: {
        filter: [_client_defaults.FINAL_SUMMARY_FILTER, {
          term: {
            test_run_id: testRunId
          }
        }]
      }
    },
    size: 1000
  }), [testRunId, lastRefresh], {
    name: 'TestRunData'
  });
  const lastUpdated = (0, _react.useRef)({
    checksum: '',
    time: Date.now()
  });
  (0, _react.useEffect)(() => {
    var _data$hits$hits;
    const docs = (_data$hits$hits = data === null || data === void 0 ? void 0 : data.hits.hits) !== null && _data$hits$hits !== void 0 ? _data$hits$hits : [];
    if (docs.length === 0) {
      setNumberOfRetries(prevState => prevState + 1);
    }
  }, [data]);
  return (0, _react.useMemo)(() => {
    var _data$hits$hits2;
    const docs = (_data$hits$hits2 = data === null || data === void 0 ? void 0 : data.hits.hits) !== null && _data$hits$hits2 !== void 0 ? _data$hits$hits2 : [];

    // Whenever a new found document is fetched, update lastUpdated
    const docsChecksum = docs.map(({
      _id
    }) => _id).reduce((acc, cur) => acc + cur, '');
    if (docsChecksum !== lastUpdated.current.checksum) {
      // Mutating lastUpdated
      lastUpdated.current.checksum = docsChecksum;
      lastUpdated.current.time = Date.now();
    }
    if (docs.length > 0) {
      if (docs.length >= expectSummaryDocs) {
        clearInterval(refreshTimer);
      }
      return {
        data,
        loading,
        summaryDocs: docs.map(doc => {
          var _doc$_source;
          return {
            ...doc._source,
            timestamp: (_doc$_source = doc._source) === null || _doc$_source === void 0 ? void 0 : _doc$_source['@timestamp'],
            docId: doc._id
          };
        }),
        lastUpdated: lastUpdated.current.time
      };
    }
    return {
      retriesExceeded: numberOfRetries > MAX_RETRIES,
      data,
      loading,
      summaryDocs: null,
      lastUpdated: lastUpdated.current.time
    };
  }, [data, numberOfRetries, loading, expectSummaryDocs, refreshTimer]);
};
exports.useSimpleRunOnceMonitors = useSimpleRunOnceMonitors;