"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallTickAxis = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _styles = require("../styles");
var _waterfall_chart_fixed_axis = require("../waterfall_chart_fixed_axis");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_waterfall_chart/waterfall/waterfall_header/waterfall_tick_axis.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const WaterfallTickAxis = ({
  showOnlyHighlightedNetworkRequests,
  setOnlyHighlighted,
  highlightedNetworkRequests,
  fetchedNetworkRequests,
  shouldRenderSidebar,
  barStyleAccessor,
  domain,
  tickFormat
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartTimeTicksContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 11
    }
  }, shouldRenderSidebar && /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarWrapper, {
    grow: _constants.SIDEBAR_GROW_SIZE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 15
    }
  }, highlightedNetworkRequests < fetchedNetworkRequests ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    role: "button",
    gutterSize: "s",
    alignItems: "center",
    "data-test-subj": "syntheticsWaterfallHideNonMatching",
    "aria-pressed": showOnlyHighlightedNetworkRequests,
    title: FILTER_COLLAPSE_REQUESTS_LABEL,
    "aria-label": FILTER_COLLAPSE_REQUESTS_LABEL,
    css: {
      marginTop: euiTheme.size.s,
      marginLeft: euiTheme.size.m,
      marginBottom: euiTheme.size.s,
      whiteSpace: 'nowrap',
      cursor: 'pointer',
      color: euiTheme.colors.textPrimary
    },
    onClick: () => {
      setOnlyHighlighted(!showOnlyHighlightedNetworkRequests);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: showOnlyHighlightedNetworkRequests ? 'eyeClosed' : 'eye',
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.waterfall.networkRequests.filteredOut",
    defaultMessage: "Filtered out",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 25
    }
  })))) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      outline: 0,
      marginLeft: '-16px',
      height: 40
    },
    grow: shouldRenderSidebar ? _constants.MAIN_GROW_SIZE : true,
    "data-test-subj": "axisOnlyWrapper",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_waterfall_chart_fixed_axis.WaterfallChartFixedAxis, {
    domain: domain,
    barStyleAccessor: barStyleAccessor,
    tickFormat: tickFormat,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  }))))));
};
exports.WaterfallTickAxis = WaterfallTickAxis;
const FILTER_COLLAPSE_REQUESTS_LABEL = _i18n.i18n.translate('xpack.synthetics.pingList.synthetics.waterfall.filters.collapseRequestsLabel', {
  defaultMessage: 'Collapse to only show matching requests'
});