"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallSearch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _public = require("@kbn/observability-shared-plugin/public");
var _translations = require("../translations");
var _network_requests_total = require("./network_requests_total");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_waterfall_chart/waterfall/waterfall_header/waterfall_search.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WaterfallSearch = ({
  query,
  setQuery,
  totalNetworkRequests,
  highlightedNetworkRequests,
  fetchedNetworkRequests
}) => {
  const trackMetric = (0, _public.useUiTracker)({
    app: 'uptime'
  });
  const [value, setValue] = (0, _react.useState)(query);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  (0, _useDebounce.default)(() => {
    setQuery(value);
  }, 300, [value]);

  // indicates use of the query input box
  (0, _react.useEffect)(() => {
    if (query) {
      trackMetric({
        metric: 'waterfall_filter_input_changed',
        metricType: _public.METRIC_TYPE.CLICK
      });
    }
  }, [query, trackMetric]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "spaceBetween",
    gutterSize: "s",
    style: {
      marginRight: euiTheme.size.l
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, NETWORK_REQUESTS_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "syntheticsWaterfallSearchFieldSearch",
    fullWidth: true,
    "aria-label": _translations.FILTER_REQUESTS_LABEL,
    placeholder: _translations.SEARCH_REQUESTS_LABEL,
    onChange: evt => {
      setValue(evt.target.value);
    },
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_network_requests_total.NetworkRequestsTotal, {
    totalNetworkRequests: totalNetworkRequests,
    highlightedNetworkRequests: highlightedNetworkRequests,
    fetchedNetworkRequests: fetchedNetworkRequests,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }));
};
exports.WaterfallSearch = WaterfallSearch;
const NETWORK_REQUESTS_LABEL = _i18n.i18n.translate('xpack.synthetics.waterfall.networkRequests.heading', {
  defaultMessage: 'Network Requests'
});