"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatMillisecond = exports.StepMetrics = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _thershold_indicator = require("../../common/components/thershold_indicator");
var _definitions_popover = require("./definitions_popover");
var _use_step_metrics = require("../hooks/use_step_metrics");
var _use_step_prev_metrics = require("../hooks/use_step_prev_metrics");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/step_details_page/step_metrics/step_metrics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const formatMillisecond = ms => {
  if (ms < 0) {
    return '- ms';
  }
  if (ms < 1000) {
    return `${ms.toFixed(0)} ms`;
  }
  return `${(ms / 1000).toFixed(1)} s`;
};
exports.formatMillisecond = formatMillisecond;
const StepMetrics = () => {
  const {
    metrics: stepMetrics
  } = (0, _use_step_metrics.useStepMetrics)();
  const {
    metrics: prevMetrics,
    loading
  } = (0, _use_step_prev_metrics.useStepPrevMetrics)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 13
    }
  }, METRICS_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_definitions_popover.DefinitionsPopover, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "l",
    columns: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, stepMetrics.map(({
    label,
    value,
    helpText,
    formatted
  }) => {
    var _prevVal$value;
    const prevVal = prevMetrics.find(prev => prev.label === label);
    if (label) return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: label,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_thershold_indicator.ThresholdIndicator, {
      asStat: true,
      loading: loading,
      description: label,
      current: value !== null && value !== void 0 ? value : 0,
      previous: (_prevVal$value = prevVal === null || prevVal === void 0 ? void 0 : prevVal.value) !== null && _prevVal$value !== void 0 ? _prevVal$value : 0,
      helpText: helpText,
      currentFormatted: formatted,
      previousFormatted: prevVal === null || prevVal === void 0 ? void 0 : prevVal.formatted,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 17
      }
    }));
  })));
};
exports.StepMetrics = StepMetrics;
const METRICS_LABEL = _i18n.i18n.translate('xpack.synthetics.stepDetailsRoute.metrics', {
  defaultMessage: 'Metrics'
});