"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatAge = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatAge = age => {
  if (!age) {
    return '--';
  }
  const [value] = age.split('d');
  return _i18n.i18n.translate('xpack.synthetics.settingsRoute.table.retentionPeriodValue', {
    defaultMessage: '{value} {value, plural, one {day} other {days}} + rollover',
    values: {
      value
    }
  });
};
exports.formatAge = formatAge;