"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceSelector = exports.ALL_SPACES_LABEL = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _public2 = require("@kbn/security-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/settings/components/spaces_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SpaceSelector = ({
  helpText,
  isDisabled = false
}) => {
  var _services$spaces;
  const NAMESPACES_NAME = 'spaces';
  const {
    services
  } = (0, _public.useKibana)();
  const [spacesList, setSpacesList] = _react.default.useState([]);
  const data = (_services$spaces = services.spaces) === null || _services$spaces === void 0 ? void 0 : _services$spaces.ui.useSpaces();
  const {
    control,
    formState: {
      isSubmitted
    },
    trigger
  } = (0, _reactHookForm.useFormContext)();
  const {
    isTouched,
    error
  } = control.getFieldState(NAMESPACES_NAME);
  const showFieldInvalid = (isSubmitted || isTouched) && !!error;
  (0, _react.useEffect)(() => {
    if (data !== null && data !== void 0 && data.spacesDataPromise) {
      data.spacesDataPromise.then(spacesData => {
        setSpacesList([allSpacesOption, ...[...spacesData.spacesMap].map(([spaceId, dataS]) => ({
          id: spaceId,
          label: dataS.name
        }))]);
      });
    }
  }, [data]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: SPACES_LABEL,
    helpText: helpText,
    isInvalid: showFieldInvalid,
    error: showFieldInvalid ? NAMESPACES_NAME : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: NAMESPACES_NAME,
    control: control,
    rules: {
      required: true
    },
    render: ({
      field
    }) => {
      var _field$value;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
        isDisabled: isDisabled,
        fullWidth: true,
        "aria-label": SPACES_LABEL,
        placeholder: SPACES_LABEL,
        isInvalid: showFieldInvalid
      }, field, {
        onBlur: async () => {
          await trigger();
        },
        options: spacesList,
        selectedOptions: ((_field$value = field.value) !== null && _field$value !== void 0 ? _field$value : []).map(id => {
          const sp = spacesList.find(space => space.id === id);
          if (!sp) {
            return {
              id,
              label: id
            };
          }
          return {
            id: sp.id,
            label: sp.label
          };
        }),
        isClearable: true,
        onChange: selected => {
          const selectedIds = selected.map(option => option.id);

          // if last value is not all spaces, remove all spaces value
          if (selectedIds.length > 0 && selectedIds[selectedIds.length - 1] !== allSpacesOption.id) {
            field.onChange(selectedIds.filter(id => id !== allSpacesOption.id));
            return;
          }

          // if last value is all spaces, remove all other values
          if (selectedIds.length > 0 && selectedIds[selectedIds.length - 1] === allSpacesOption.id) {
            field.onChange([allSpacesOption.id]);
            return;
          }
          field.onChange(selectedIds);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 11
        }
      }));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }));
};
exports.SpaceSelector = SpaceSelector;
const ALL_SPACES_LABEL = exports.ALL_SPACES_LABEL = _i18n.i18n.translate('xpack.synthetics.spaceList.allSpacesLabel', {
  defaultMessage: `* All spaces`
});
const allSpacesOption = {
  id: _public2.ALL_SPACES_ID,
  label: ALL_SPACES_LABEL
};
const SPACES_LABEL = _i18n.i18n.translate('xpack.synthetics.privateLocation.spacesLabel', {
  defaultMessage: 'Spaces '
});