"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuickFilters = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_overview_status = require("../../hooks/use_overview_status");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/quick_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const QuickFilters = () => {
  const {
    statusFilter
  } = (0, _hooks.useGetUrlParams)();
  const [_, updateUrlParams] = (0, _hooks.useUrlParams)();
  const {
    status
  } = (0, _use_overview_status.useOverviewStatus)({
    scopeStatusByLocation: true
  });
  const handleFilterUpdate = monitorStatus => {
    updateUrlParams({
      statusFilter: statusFilter !== monitorStatus ? monitorStatus : undefined
    });
  };
  const statusButtons = [{
    id: 'up',
    label: UP_LABEL
  }, {
    id: 'down',
    label: DOWN_LABEL
  }, {
    id: 'disabled',
    label: DISABLED_LABEL
  }];
  if (status !== null && status !== void 0 && status.pending && (status === null || status === void 0 ? void 0 : status.pending) > 0) {
    statusButtons.push({
      id: 'pending',
      label: PENDING_LABEL
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    buttonSize: "m",
    legend: _i18n.i18n.translate('xpack.synthetics.overview.status.filters.legend', {
      defaultMessage: 'Monitor status'
    }),
    options: statusButtons,
    idSelected: statusFilter,
    onChange: handleFilterUpdate,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  });
};
exports.QuickFilters = QuickFilters;
const DOWN_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.status.filters.down', {
  defaultMessage: 'Down'
});
const UP_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.status.filters.up', {
  defaultMessage: 'Up'
});
const DISABLED_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.status.filters.disabled', {
  defaultMessage: 'Disabled'
});
const PENDING_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.status.filters.pending', {
  defaultMessage: 'Pending'
});