"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingState = LoadingState;
exports.MaybeMonitorDetailsFlyout = void 0;
exports.MonitorDetailFlyout = MonitorDetailFlyout;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _use_kibana_space = require("../../../../../../hooks/use_kibana_space");
var _use_monitor_detail = require("../../../../hooks/use_monitor_detail");
var _use_monitor_detail_locator = require("../../../../hooks/use_monitor_detail_locator");
var _use_status_by_location = require("../../../../hooks/use_status_by_location");
var _state = require("../../../../state");
var _monitor_details_panel = require("../../../common/components/monitor_details_panel");
var _monitor_location_select = require("../../../common/components/monitor_location_select");
var _error_callout = require("../../../common/components/error_callout");
var _monitor_status = require("../../../common/components/monitor_status");
var _use_overview_status = require("../../hooks/use_overview_status");
var _monitor_enabled = require("../../management/monitor_list_table/monitor_enabled");
var _types = require("../types");
var _actions_popover = require("./actions_popover");
var _overview_status = require("../../../../state/overview_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/monitor_detail_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_DURATION_CHART_FROM = 'now-12h';
const DEFAULT_CURRENT_DURATION_CHART_TO = 'now';
const DEFAULT_PREVIOUS_DURATION_CHART_FROM = 'now-24h';
const DEFAULT_PREVIOUS_DURATION_CHART_TO = 'now-12h';
function DetailFlyoutDurationChart({
  id,
  location,
  currentDurationChartFrom,
  currentDurationChartTo,
  previousDurationChartFrom,
  previousDurationChartTo
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
    bottomBorder: "extended",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }, DURATION_HEADER_TEXT)), /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    customHeight: "200px",
    reportType: "kpi-over-time",
    axisTitlesVisibility: {
      x: false,
      yRight: false,
      yLeft: false
    },
    legendIsVisible: true,
    legendPosition: "bottom",
    attributes: [{
      seriesType: 'area',
      color: euiTheme.colors.vis.euiColorVis1,
      time: {
        from: currentDurationChartFrom !== null && currentDurationChartFrom !== void 0 ? currentDurationChartFrom : DEFAULT_DURATION_CHART_FROM,
        to: currentDurationChartTo !== null && currentDurationChartTo !== void 0 ? currentDurationChartTo : DEFAULT_CURRENT_DURATION_CHART_TO
      },
      reportDefinitions: {
        'monitor.id': [id],
        'observer.geo.name': [location]
      },
      filters: [{
        field: 'observer.geo.name',
        values: [location]
      }],
      dataType: 'synthetics',
      selectedMetricField: 'monitor.duration.us',
      name: DURATION_SERIES_NAME,
      operationType: 'average'
    }, {
      seriesType: 'line',
      color: euiTheme.colors.vis.euiColorVis7,
      time: {
        from: previousDurationChartFrom !== null && previousDurationChartFrom !== void 0 ? previousDurationChartFrom : DEFAULT_PREVIOUS_DURATION_CHART_FROM,
        to: previousDurationChartTo !== null && previousDurationChartTo !== void 0 ? previousDurationChartTo : DEFAULT_PREVIOUS_DURATION_CHART_TO
      },
      reportDefinitions: {
        'monitor.id': [id],
        'observer.geo.name': [location]
      },
      filters: [{
        field: 'observer.geo.name',
        values: [location]
      }],
      dataType: 'synthetics',
      selectedMetricField: 'monitor.duration.us',
      name: PREVIOUS_PERIOD_SERIES_NAME,
      operationType: 'average'
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }));
}
function DetailedFlyoutHeader({
  locations,
  currentLocation,
  configId,
  setCurrentLocation,
  monitor,
  onEnabledChange
}) {
  var _locations$find;
  const status = (_locations$find = locations.find(l => l.label === currentLocation)) === null || _locations$find === void 0 ? void 0 : _locations$find.status;
  const {
    locations: allLocations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  const selectedLocation = allLocations.find(ll => ll.label === currentLocation);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_status.MonitorStatus, {
    status: status,
    monitor: monitor,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_location_select.MonitorLocationSelect, {
    compressed: true,
    monitorLocations: monitor.locations,
    configId: configId,
    selectedLocation: selectedLocation,
    onChange: (0, _react.useCallback)((id, label) => {
      if (currentLocation !== label) setCurrentLocation(label, id);
    }, [currentLocation, setCurrentLocation]),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    align: "left",
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 11
    }
  }, ENABLED_ITEM_TEXT), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_enabled.MonitorEnabled, {
    configId: configId,
    monitor: monitor,
    reloadPage: onEnabledChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  })))));
}
function LoadingState() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    css: {
      height: '100%'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  })));
}
function MonitorDetailFlyout(props) {
  const {
    id,
    configId,
    onLocationChange,
    locationId,
    spaces
  } = props;
  const {
    status: overviewStatus
  } = (0, _use_overview_status.useOverviewStatus)({
    scopeStatusByLocation: true
  });
  const monitor = (0, _react.useMemo)(() => {
    var _overviewStatus$upCon, _overviewStatus$downC;
    const allConfigs = Object.values({
      ...((_overviewStatus$upCon = overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.upConfigs) !== null && _overviewStatus$upCon !== void 0 ? _overviewStatus$upCon : {}),
      ...((_overviewStatus$downC = overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.downConfigs) !== null && _overviewStatus$downC !== void 0 ? _overviewStatus$downC : {})
    });
    const overviewItem = allConfigs.find(ov => ov.configId === configId);
    if (overviewItem) return overviewItem;
  }, [overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.upConfigs, overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.downConfigs, configId]);
  const setLocation = (0, _react.useCallback)((location, locationIdT) => onLocationChange({
    id,
    configId,
    location,
    locationId: locationIdT,
    spaces
  }), [onLocationChange, id, configId, spaces]);
  const detailLink = (0, _use_monitor_detail_locator.useMonitorDetailLocator)({
    configId,
    locationId,
    spaces
  });
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    return () => {
      dispatch((0, _state.setFlyoutConfig)(null));
    };
  }, [dispatch]);
  const upsertStatus = (0, _reactRedux.useSelector)((0, _state.selectMonitorUpsertStatus)(configId));
  const monitorObject = (0, _reactRedux.useSelector)(_state.selectSyntheticsMonitor);
  const isLoading = (0, _reactRedux.useSelector)(_state.selectSyntheticsMonitorLoading);
  const error = (0, _reactRedux.useSelector)(_state.selectSyntheticsMonitorError);
  const upsertSuccess = (upsertStatus === null || upsertStatus === void 0 ? void 0 : upsertStatus.status) === 'success';
  const {
    space
  } = (0, _use_kibana_space.useKibanaSpace)();
  (0, _react.useEffect)(() => {
    dispatch(_state.getMonitorAction.get({
      monitorId: configId,
      ...(space && spaces !== null && spaces !== void 0 && spaces.length && !(spaces !== null && spaces !== void 0 && spaces.includes(space === null || space === void 0 ? void 0 : space.id)) ? {
        spaceId: spaces[0]
      } : {})
    }));
  }, [configId, dispatch, space, space === null || space === void 0 ? void 0 : space.id, spaces, upsertSuccess]);
  const [isActionsPopoverOpen, setIsActionsPopoverOpen] = (0, _react.useState)(false);
  const monitorDetail = (0, _use_monitor_detail.useMonitorDetail)(configId, props.location);
  const {
    locations
  } = (0, _use_status_by_location.useStatusByLocation)({
    configId,
    monitorLocations: monitorObject === null || monitorObject === void 0 ? void 0 : monitorObject.locations
  });
  const isOverlay = (0, _eui.useIsWithinMaxBreakpoint)('xl');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "600px",
    type: isOverlay ? 'overlay' : 'push',
    onClose: props.onClose,
    paddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 5
    }
  }, error && !isLoading && /*#__PURE__*/_react.default.createElement(_error_callout.ErrorCallout, (0, _extends2.default)({}, error, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 31
    }
  })), isLoading && /*#__PURE__*/_react.default.createElement(LoadingState, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 21
    }
  }), monitorObject && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 21
    }
  }, monitorObject === null || monitorObject === void 0 ? void 0 : monitorObject[_types.ConfigKey.NAME]))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 17
    }
  }, monitor && /*#__PURE__*/_react.default.createElement(_actions_popover.ActionsPopover, {
    isPopoverOpen: isActionsPopoverOpen,
    isInspectView: true,
    monitor: monitor,
    setIsPopoverOpen: setIsActionsPopoverOpen,
    position: "default",
    iconHasPanel: false,
    iconSize: "xs",
    locationId: locationId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(DetailedFlyoutHeader, {
    currentLocation: props.location,
    locations: locations,
    setCurrentLocation: setLocation,
    configId: configId,
    monitor: monitorObject,
    onEnabledChange: props.onEnabledChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(DetailFlyoutDurationChart, (0, _extends2.default)({}, props, {
    location: props.location,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_monitor_details_panel.MonitorDetailsPanel, {
    hasBorder: false,
    hideEnabled: true,
    latestPing: monitorDetail.data,
    configId: configId,
    monitor: {
      ...monitorObject,
      id
    },
    loading: Boolean(isLoading),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "l",
    color: "transparent",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsMonitorDetailFlyoutButton",
    onClick: props.onClose,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 349,
      columnNumber: 19
    }
  }, CLOSE_FLYOUT_TEXT)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsMonitorDetailFlyoutButton"
    // `detailLink` can be undefined, in this case, disable the button
    ,
    isDisabled: !detailLink,
    href: detailLink,
    iconType: "sortRight",
    iconSide: "right",
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 357,
      columnNumber: 19
    }
  }, GO_TO_MONITOR_LINK_TEXT)))))));
}
const MaybeMonitorDetailsFlyout = ({
  setFlyoutConfigCallback
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    flyoutConfig,
    pageState
  } = (0, _reactRedux.useSelector)(_state.selectOverviewState);
  const hideFlyout = (0, _react.useCallback)(() => dispatch((0, _state.setFlyoutConfig)(null)), [dispatch]);
  const forceRefreshCallback = (0, _react.useCallback)(() => dispatch(_overview_status.quietFetchOverviewStatusAction.get({
    pageState
  })), [dispatch, pageState]);
  return flyoutConfig !== null && flyoutConfig !== void 0 && flyoutConfig.configId && flyoutConfig !== null && flyoutConfig !== void 0 && flyoutConfig.location ? /*#__PURE__*/_react.default.createElement(MonitorDetailFlyout, {
    configId: flyoutConfig.configId,
    id: flyoutConfig.id,
    location: flyoutConfig.location,
    locationId: flyoutConfig.locationId,
    spaces: flyoutConfig.spaces,
    onClose: hideFlyout,
    onEnabledChange: forceRefreshCallback,
    onLocationChange: setFlyoutConfigCallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 393,
      columnNumber: 5
    }
  }) : null;
};
exports.MaybeMonitorDetailsFlyout = MaybeMonitorDetailsFlyout;
const DURATION_HEADER_TEXT = _i18n.i18n.translate('xpack.synthetics.monitorList.durationHeaderText', {
  defaultMessage: 'Duration'
});
const DURATION_SERIES_NAME = _i18n.i18n.translate('xpack.synthetics.monitorList.durationChart.durationSeriesName', {
  defaultMessage: 'Duration'
});
const PREVIOUS_PERIOD_SERIES_NAME = _i18n.i18n.translate('xpack.synthetics.monitorList.durationChart.previousPeriodSeriesName', {
  defaultMessage: 'Previous period'
});
const ENABLED_ITEM_TEXT = _i18n.i18n.translate('xpack.synthetics.monitorList.enabledItemText', {
  defaultMessage: 'Enabled (all locations)'
});
const CLOSE_FLYOUT_TEXT = _i18n.i18n.translate('xpack.synthetics.monitorList.closeFlyoutText', {
  defaultMessage: 'Close'
});
const GO_TO_MONITOR_LINK_TEXT = _i18n.i18n.translate('xpack.synthetics.monitorList.goToMonitorLinkText', {
  defaultMessage: 'Go to monitor'
});