"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricItemIcon = void 0;
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _i18n = require("@kbn/i18n");
var _use_monitor_mws = require("../../../hooks/use_monitor_mws");
var _metric_error_icon = require("./metric_error_icon");
var _manual_test_runs = require("../../../../../state/manual_test_runs");
var _state = require("../../../../../state");
var _error_details_link = require("../../../../common/links/error_details_link");
var _use_date_format = require("../../../../../../../hooks/use_date_format");
var _use_latest_error = require("./use_latest_error");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/metric_item/metric_item_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Container = _styled.default.div`
  display: inline-block;
  position: absolute;
  right: 10px;
  top: 10px;
  z-index: 1;
`;
const MetricItemIcon = ({
  monitor,
  status,
  timestamp,
  configIdByLocation
}) => {
  var _latestPing$state;
  const testNowRun = (0, _reactRedux.useSelector)((0, _manual_test_runs.manualTestRunSelector)(monitor.configId));
  const isPopoverOpen = (0, _reactRedux.useSelector)(_state.selectErrorPopoverState);
  const {
    latestPing
  } = (0, _use_latest_error.useLatestError)({
    configIdByLocation,
    monitorId: monitor.configId,
    locationLabel: monitor.locationLabel
  });
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    activeMWs
  } = (0, _use_monitor_mws.useMonitorMWs)(monitor);
  const inProgress = (0, _manual_test_runs.isTestRunning)(testNowRun);
  const errorLink = (0, _error_details_link.useErrorDetailsLink)({
    configId: monitor.configId,
    stateId: latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$state = latestPing.state) === null || _latestPing$state === void 0 ? void 0 : _latestPing$state.id,
    locationId: monitor.locationId
  });
  const formatter = (0, _use_date_format.useDateFormat)();
  const testTime = formatter(timestamp);
  if (inProgress) {
    return /*#__PURE__*/React.createElement(Container, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 7
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiToolTip, {
      position: "top",
      content: TEST_IN_PROGRESS,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 11
      }
    })));
  }
  if (activeMWs.length) {
    return /*#__PURE__*/React.createElement(Container, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 7
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.synthetics.metricItemIcon.euiButtonIcon.maintenanceWindowActive', {
        defaultMessage: 'Monitor is stopped while maintenance windows are running.'
      }),
      type: "pause",
      color: "warning",
      iconProps: {
        'data-test-subj': 'syntheticsMetricItemIconButton'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 9
      }
    }));
  }
  const closePopover = () => {
    dispatch((0, _state.toggleErrorPopoverOpen)(null));
  };
  if (status === 'down') {
    var _latestPing$url, _latestPing$error, _latestPing$error2;
    return /*#__PURE__*/React.createElement(Container, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 7
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/React.createElement(_metric_error_icon.MetricErrorIcon, {
        configIdByLocation: configIdByLocation,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 19
        }
      }),
      isOpen: configIdByLocation === isPopoverOpen,
      closePopover: closePopover,
      anchorPosition: "upCenter",
      panelStyle: {
        outline: 'none'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 9
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiPopoverTitle, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 11
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 13
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 15
      }
    }, testTime), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 15
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "syntheticsMetricItemIconButton",
      iconType: "cross",
      onClick: closePopover,
      "aria-label": _i18n.i18n.translate('xpack.synthetics.metricItemIcon.euiButtonIcon.closePopover', {
        defaultMessage: 'Close popover'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 17
      }
    })))), /*#__PURE__*/React.createElement("div", {
      style: {
        width: '300px',
        overflowWrap: 'break-word'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    }, (latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$url = latestPing.url) === null || _latestPing$url === void 0 ? void 0 : _latestPing$url.full) && /*#__PURE__*/React.createElement(React.Fragment, null, _i18n.i18n.translate('xpack.synthetics.metricItemIcon.div.urlLabel', {
      defaultMessage: 'URL: '
    }), /*#__PURE__*/React.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsMetricItemIconLink",
      href: latestPing.url.full,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 149,
        columnNumber: 17
      }
    }, latestPing.url.full), /*#__PURE__*/React.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 17
      }
    })), /*#__PURE__*/React.createElement(_eui.EuiCallOut, {
      title: latestPing !== null && latestPing !== void 0 && (_latestPing$error = latestPing.error) !== null && _latestPing$error !== void 0 && _latestPing$error.message ? latestPing === null || latestPing === void 0 ? void 0 : (_latestPing$error2 = latestPing.error) === null || _latestPing$error2 === void 0 ? void 0 : _latestPing$error2.message : /*#__PURE__*/React.createElement(_eui.EuiSkeletonText, {
        lines: 2,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 164,
          columnNumber: 19
        }
      }),
      color: "danger",
      iconType: "warning",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 13
      }
    })), /*#__PURE__*/React.createElement(_eui.EuiPopoverFooter, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 11
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiButton, {
      "data-test-subj": "syntheticsMetricItemIconButton",
      fullWidth: true,
      size: "s",
      href: errorLink,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 13
      }
    }, ERROR_DETAILS))));
  } else {
    if (latestPing !== null && latestPing !== void 0 && latestPing.url) {
      return /*#__PURE__*/React.createElement(Container, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 9
        }
      }, /*#__PURE__*/React.createElement(_eui.EuiButtonIcon, {
        title: latestPing.url.full,
        color: "text",
        "data-test-subj": "syntheticsMetricItemIconButton",
        href: latestPing.url.full,
        iconType: "link",
        target: "_blank",
        "aria-label": _i18n.i18n.translate('xpack.synthetics.metricItemIcon.euiButtonIcon.monitorUrl', {
          defaultMessage: 'Monitor url'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 11
        }
      }));
    }
    return null;
  }
};
exports.MetricItemIcon = MetricItemIcon;
const ERROR_DETAILS = _i18n.i18n.translate('xpack.synthetics.errorDetails.label', {
  defaultMessage: 'Error details'
});
const TEST_IN_PROGRESS = _i18n.i18n.translate('xpack.synthetics.inProgress.label', {
  defaultMessage: 'Manual test run is in progress.'
});