"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupFields = exports.GROUP_TITLE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
var _group_menu = require("./group_menu");
var _runtime_types = require("../../../../../../../../common/runtime_types");
var _overview = require("../../../../../state/overview");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/grid_by_group/group_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GroupFields = () => {
  const {
    groupBy: {
      field: groupField,
      order: groupOrder
    }
  } = (0, _reactRedux.useSelector)(_overview.selectOverviewState);
  const dispatch = (0, _reactRedux.useDispatch)();
  const [urlParams, updateUrlParams] = (0, _hooks.useUrlParams)();
  const {
    groupBy: urlGroupField,
    groupOrderBy: urlGroupOrderBy
  } = urlParams();
  const isUrlHydratedFromRedux = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    if (urlGroupField !== groupField) {
      if (!urlGroupField && groupField !== 'none' && !isUrlHydratedFromRedux.current) {
        // Hydrate url only during initialization
        updateUrlParams({
          groupBy: groupField,
          groupOrderBy: groupOrder
        });
      }
    }
    isUrlHydratedFromRedux.current = true;

    // Only depend on the serialized snapshot
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [dispatch, groupField, groupOrder, urlGroupField, urlGroupOrderBy]);
  const isUReduxHydratedFromUrl = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    if (urlGroupField && urlGroupField !== groupField && !isUReduxHydratedFromUrl.current) {
      dispatch((0, _overview.setOverviewGroupByAction)({
        field: urlGroupField !== null && urlGroupField !== void 0 ? urlGroupField : 'none',
        order: urlGroupOrderBy !== null && urlGroupOrderBy !== void 0 ? urlGroupOrderBy : 'asc'
      }));
    }
    isUReduxHydratedFromUrl.current = true;
    // Only depend on the serialized snapshot
  }, [dispatch, groupField, groupOrder, urlGroupField, urlGroupOrderBy]);
  const handleChange = groupByState => {
    dispatch((0, _overview.setOverviewGroupByAction)(groupByState));
    updateUrlParams({
      groupBy: groupByState.field,
      groupOrderBy: groupByState.order
    });
  };
  const groupByOptions = [{
    label: NONE_LABEL,
    value: 'none',
    checked: groupField === 'none',
    defaultSortOrder: 'asc',
    onClick: () => {
      handleChange({
        field: 'none',
        order: groupOrder
      });
    }
  }, {
    label: LOCATION_LABEL,
    value: 'location.id',
    checked: groupField === 'locationId',
    defaultSortOrder: 'asc',
    onClick: () => {
      handleChange({
        field: 'locationId',
        order: groupOrder
      });
    }
  }, {
    label: MONITOR_TYPE_LABEL,
    value: _runtime_types.ConfigKey.MONITOR_TYPE,
    checked: groupField === _runtime_types.ConfigKey.MONITOR_TYPE,
    defaultSortOrder: 'desc',
    onClick: () => {
      handleChange({
        field: _runtime_types.ConfigKey.MONITOR_TYPE,
        order: groupOrder
      });
    }
  }, {
    label: TAG_LABEL,
    value: _runtime_types.ConfigKey.TAGS,
    checked: groupField === _runtime_types.ConfigKey.TAGS,
    defaultSortOrder: 'desc',
    onClick: () => {
      handleChange({
        field: _runtime_types.ConfigKey.TAGS,
        order: groupOrder
      });
    }
  }, {
    label: PROJECT_LABEL,
    value: _runtime_types.ConfigKey.PROJECT_ID,
    checked: groupField === _runtime_types.ConfigKey.PROJECT_ID,
    defaultSortOrder: 'desc',
    onClick: () => {
      handleChange({
        field: _runtime_types.ConfigKey.PROJECT_ID,
        order: groupOrder
      });
    }
  }];
  const {
    asc,
    desc,
    label
  } = getOrderContent(groupField);
  const orderByOptions = [{
    label: asc,
    value: 'asc',
    checked: groupOrder === 'asc',
    onClick: () => {
      handleChange({
        field: groupField,
        order: 'asc'
      });
    }
  }, {
    label: desc,
    value: 'desc',
    checked: groupOrder === 'desc',
    onClick: () => {
      handleChange({
        field: groupField,
        order: 'desc'
      });
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "none",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  }, GROUP_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "syntheticsOverviewGroupButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_group_menu.GroupMenu, {
    groupOptions: groupByOptions,
    orderByOptions: orderByOptions,
    groupField: label,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 13
    }
  })))));
};
exports.GroupFields = GroupFields;
const getOrderContent = groupField => {
  switch (groupField) {
    case 'locationId':
      return {
        asc: SORT_ALPHABETICAL_ASC,
        desc: SORT_ALPHABETICAL_DESC,
        label: LOCATION_LABEL
      };
    case _runtime_types.ConfigKey.MONITOR_TYPE:
      return {
        asc: SORT_ALPHABETICAL_ASC,
        desc: SORT_ALPHABETICAL_DESC,
        label: MONITOR_TYPE_LABEL
      };
    case _runtime_types.ConfigKey.TAGS:
      return {
        asc: SORT_ALPHABETICAL_ASC,
        desc: SORT_ALPHABETICAL_DESC,
        label: TAG_LABEL
      };
    case _runtime_types.ConfigKey.PROJECT_ID:
      return {
        asc: SORT_ALPHABETICAL_ASC,
        desc: SORT_ALPHABETICAL_DESC,
        label: PROJECT_LABEL
      };
    default:
      return {
        asc: ASCENDING_LABEL,
        desc: DESCENDING_LABEL,
        label: NONE_LABEL
      };
  }
};
const GROUP_TITLE = exports.GROUP_TITLE = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.group.title', {
  defaultMessage: 'Group by'
});
const SORT_ALPHABETICAL_ASC = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.alphabetical.asc', {
  defaultMessage: 'A -> Z',
  description: 'Describes ascending alphabetical sort order'
});
const SORT_ALPHABETICAL_DESC = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.alphabetical.desc', {
  defaultMessage: 'Z -> A',
  description: 'Describes descending alphabetical sort order'
});
const ASCENDING_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.ascending.label', {
  defaultMessage: 'Ascending'
});
const DESCENDING_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.descending.label', {
  defaultMessage: 'Descending'
});
const NONE_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.none.label', {
  defaultMessage: 'None'
});
const LOCATION_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.location.label', {
  defaultMessage: 'Location'
});
const MONITOR_TYPE_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.monitorType.label', {
  defaultMessage: 'Monitor type'
});
const TAG_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.tag.label', {
  defaultMessage: 'Tag'
});
const PROJECT_LABEL = _i18n.i18n.translate('xpack.synthetics.overview.groupPopover.project.label', {
  defaultMessage: 'Project'
});