"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorsTablePagination = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findMonitors = (monitors, pageIndex, pageSize) => {
  let pageOfItems;
  if (!pageIndex && !pageSize) {
    pageOfItems = monitors;
  } else {
    const startIndex = pageIndex * pageSize;
    pageOfItems = monitors.slice(startIndex, Math.min(startIndex + pageSize, monitors.length));
  }
  return {
    pageOfItems,
    totalItemCount: monitors.length
  };
};
const useMonitorsTablePagination = ({
  totalItems
}) => {
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const onTableChange = ({
    page
  }) => {
    if (page) {
      setPageIndex(page.index);
      setPageSize(page.size);
    }
  };
  const {
    pageOfItems,
    totalItemCount
  } = findMonitors(totalItems, pageIndex, pageSize);
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount,
    pageSizeOptions: [5, 10, 25, 50, 100]
  };
  return {
    onTableChange,
    pageOfItems,
    pagination
  };
};
exports.useMonitorsTablePagination = useMonitorsTablePagination;