"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsPopover = ActionsPopover;
exports.enabledFailLabel = exports.disabledSuccessLabel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public2 = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../../embeddables/constants");
var _use_create_slo = require("../../hooks/use_create_slo");
var _run_test_btn = require("../../../monitor_add_edit/form/run_test_btn");
var _use_can_use_public_loc_id = require("../../hooks/use_can_use_public_loc_id");
var _alert_config = require("../../../../../../../common/runtime_types/monitor_management/alert_config");
var _manual_test_runs = require("../../../../state/manual_test_runs");
var _use_monitor_alert_enable = require("../../../../hooks/use_monitor_alert_enable");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _use_capabilities = require("../../../../../../hooks/use_capabilities");
var _hooks = require("../../../../hooks");
var _actions = require("../../../../state/overview/actions");
var _use_edit_monitor_locator = require("../../../../hooks/use_edit_monitor_locator");
var _use_monitor_detail_locator = require("../../../../hooks/use_monitor_detail_locator");
var _permissions = require("../../../common/components/permissions");
var _add_to_dashboard = require("../../../common/components/add_to_dashboard");
var _state = require("../../../../state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/overview/overview/actions_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Container = _styledComponents.default.div`
  ${({
  position
}) => position === 'relative' ?
// custom styles used to overlay the popover button on `MetricItem`
`
  display: inline-block;
  position: relative;
  bottom: 42px;
  left: 12px;
  z-index: 1;
` :
// otherwise, no custom position needed
''}

  border-radius: ${({
  theme
}) => theme.eui.euiBorderRadius};
  ${({
  boxShadow,
  position
}) => position === 'relative' ? boxShadow : ''}
`;
const CustomShadowPanel = (0, _styledComponents.default)(_eui.EuiPanel)`
  ${props => props.shadow}
`;
function IconPanel({
  children,
  hasPanel
}) {
  const shadow = (0, _eui.useEuiShadow)('s');
  if (!hasPanel) return children;
  return /*#__PURE__*/_react.default.createElement(CustomShadowPanel, {
    color: "plain",
    element: "button",
    grow: false,
    paddingSize: "none",
    hasShadow: false,
    shadow: shadow,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  }, children);
}
function ActionsPopover({
  isPopoverOpen,
  isInspectView,
  setIsPopoverOpen,
  monitor,
  position,
  iconHasPanel = true,
  iconSize = 's',
  locationId
}) {
  const euiShadow = (0, _eui.useEuiShadow)('l');
  const dispatch = (0, _reactRedux.useDispatch)();
  const locationName = (0, _hooks.useLocationName)(monitor);
  const {
    http
  } = (0, _public2.useKibana)().services;
  const detailUrl = (0, _use_monitor_detail_locator.useMonitorDetailLocator)({
    configId: monitor.configId,
    locationId: locationId !== null && locationId !== void 0 ? locationId : monitor.locationId,
    spaces: monitor.spaces
  });
  const editUrl = (0, _use_edit_monitor_locator.useEditMonitorLocator)({
    configId: monitor.configId,
    spaces: monitor.spaces
  });
  const canEditSynthetics = (0, _use_capabilities.useCanEditSynthetics)();
  const canUsePublicLocations = (0, _use_can_use_public_loc_id.useCanUsePublicLocById)(monitor.configId);
  const {
    isServiceAllowed
  } = (0, _hooks.useEnablement)();
  const labels = (0, _react.useMemo)(() => ({
    enabledSuccessLabel: enabledSuccessLabel(monitor.name),
    disabledSuccessLabel: disabledSuccessLabel(monitor.name),
    failureLabel: enabledFailLabel(monitor.name)
  }), [monitor.name]);
  const {
    status,
    isEnabled,
    updateMonitorEnabledState
  } = (0, _hooks.useMonitorEnableHandler)({
    configId: monitor.configId,
    isEnabled: monitor.isEnabled,
    labels
  });
  const {
    alertStatus,
    updateAlertEnabledState
  } = (0, _use_monitor_alert_enable.useMonitorAlertEnable)();
  const {
    CreateSLOFlyout,
    setIsSLOFlyoutOpen
  } = (0, _use_create_slo.useCreateSLO)({
    configId: monitor.configId,
    label: monitor.name,
    tags: monitor.tags
  });
  const [enableLabel, setEnableLabel] = (0, _react.useState)(monitor.isEnabled ? disableMonitorLabel : enableMonitorLabel);
  const testInProgress = (0, _reactRedux.useSelector)((0, _manual_test_runs.manualTestRunInProgressSelector)(monitor.configId));
  const {
    view
  } = (0, _reactRedux.useSelector)(_state.selectOverviewState);
  (0, _react.useEffect)(() => {
    if (status === _public.FETCH_STATUS.LOADING) {
      setEnableLabel(loadingLabel(monitor.isEnabled));
    } else if (status === _public.FETCH_STATUS.SUCCESS) {
      setEnableLabel(isEnabled ? disableMonitorLabel : enableMonitorLabel);
      if (isPopoverOpen) setIsPopoverOpen(false);
    }
  }, [setEnableLabel, status, isEnabled, monitor.isEnabled, isPopoverOpen, setIsPopoverOpen]);
  const quickInspectPopoverItem = {
    name: quickInspectName,
    icon: 'inspect',
    disabled: !locationName,
    onClick: () => {
      if (locationName) {
        dispatch((0, _actions.setFlyoutConfig)({
          configId: monitor.configId,
          location: locationName,
          id: monitor.configId,
          locationId: monitor.locationId
        }));
        setIsPopoverOpen(false);
      }
    }
  };
  const {
    MaybeSavedObjectSaveModalDashboard,
    setDashboardAttachmentReady
  } = (0, _add_to_dashboard.useAddToDashboard)({
    type: _constants.SYNTHETICS_MONITORS_EMBEDDABLE,
    embeddableInput: {
      filters: {
        monitorIds: [{
          label: monitor.name,
          value: monitor.configId
        }],
        tags: [],
        locations: [{
          label: monitor.locationLabel,
          value: monitor.locationId
        }],
        monitorTypes: [],
        projects: []
      },
      view
    },
    documentTitle: `${monitor.name} - ${monitor.locationLabel}`,
    objectType: _i18n.i18n.translate('xpack.synthetics.overview.actions.addToDashboard.objectTypeLabel', {
      defaultMessage: 'Monitor Overview'
    })
  });
  const alertLoading = alertStatus(monitor.configId) === _public.FETCH_STATUS.LOADING;
  let popoverItems = [{
    name: actionsMenuGoToMonitorName,
    icon: 'sortRight',
    href: detailUrl,
    'data-test-subj': 'actionsPopoverGoToMonitor'
  }, quickInspectPopoverItem, {
    name: testInProgress ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _run_test_btn.TEST_SCHEDULED_LABEL,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 11
      }
    }, runTestManually)) : /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
      canUsePublicLocations: canUsePublicLocations,
      canEditSynthetics: canEditSynthetics,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 9
      }
    }, runTestManually),
    icon: 'beaker',
    disabled: testInProgress || !canUsePublicLocations || !isServiceAllowed,
    onClick: () => {
      dispatch(_manual_test_runs.manualTestMonitorAction.get({
        configId: monitor.configId,
        name: monitor.name
      }));
      dispatch((0, _actions.setFlyoutConfig)(null));
      setIsPopoverOpen(false);
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
      canEditSynthetics: canEditSynthetics,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 9
      }
    }, actionsMenuEditMonitorName),
    icon: 'pencil',
    disabled: !canEditSynthetics || !isServiceAllowed,
    href: editUrl,
    'data-test-subj': 'editMonitorLink'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
      canEditSynthetics: canEditSynthetics,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 9
      }
    }, actionsMenuCloneMonitorName),
    icon: 'copy',
    disabled: !canEditSynthetics || !isServiceAllowed,
    href: http === null || http === void 0 ? void 0 : http.basePath.prepend(`synthetics/add-monitor?cloneId=${monitor.configId}`),
    'data-test-subj': 'cloneMonitorLink'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
      canEditSynthetics: canEditSynthetics,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 259,
        columnNumber: 9
      }
    }, CREATE_SLO),
    icon: 'visGauge',
    disabled: !canEditSynthetics || !isServiceAllowed,
    onClick: () => {
      setIsPopoverOpen(false);
      setIsSLOFlyoutOpen(true);
    },
    'data-test-subj': 'createSLOBtn'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
      canEditSynthetics: canEditSynthetics,
      canUsePublicLocations: canUsePublicLocations,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 9
      }
    }, enableLabel),
    icon: 'invert',
    disabled: !canEditSynthetics || !canUsePublicLocations,
    onClick: () => {
      if (status !== _public.FETCH_STATUS.LOADING) {
        updateMonitorEnabledState(!monitor.isEnabled);
      }
    }
  }, {
    name: /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
      canEditSynthetics: canEditSynthetics,
      canUsePublicLocations: canUsePublicLocations,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 290,
        columnNumber: 9
      }
    }, monitor.isStatusAlertEnabled ? disableAlertLabel : enableMonitorAlertLabel),
    disabled: !canEditSynthetics || !canUsePublicLocations || !isServiceAllowed,
    icon: alertLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 299,
        columnNumber: 9
      }
    }) : monitor.isStatusAlertEnabled ? 'bellSlash' : 'bell',
    onClick: () => {
      if (!alertLoading) {
        updateAlertEnabledState({
          monitor: {
            [_runtime_types.ConfigKey.ALERT_CONFIG]: (0, _alert_config.toggleStatusAlert)({
              status: {
                enabled: monitor.isStatusAlertEnabled
              }
            })
          },
          configId: monitor.configId,
          name: monitor.name
        });
      }
    }
  }, {
    name: addMonitorToDashboardLabel,
    icon: 'dashboardApp',
    onClick: () => {
      setIsPopoverOpen(false);
      setDashboardAttachmentReady(true);
    }
  }];
  if (isInspectView) popoverItems = popoverItems.filter(i => i !== quickInspectPopoverItem);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Container, {
    boxShadow: euiShadow,
    position: position,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 334,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(IconPanel, {
      hasPanel: iconHasPanel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 337,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "syntheticsActionsPopoverButton",
      "aria-label": openActionsMenuAria,
      iconType: "boxesHorizontal",
      color: "primary",
      size: iconSize,
      display: "empty",
      onClick: () => setIsPopoverOpen(b => !b),
      title: openActionsMenuAria,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 338,
        columnNumber: 15
      }
    })),
    color: "lightestShade",
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    anchorPosition: "rightUp",
    panelPaddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: [{
      id: '0',
      title: actionsMenuTitle,
      items: popoverItems
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 11
    }
  }))), CreateSLOFlyout, MaybeSavedObjectSaveModalDashboard);
}
const quickInspectName = _i18n.i18n.translate('xpack.synthetics.overview.actions.quickInspect.title', {
  defaultMessage: 'Quick inspect'
});
const runTestManually = _i18n.i18n.translate('xpack.synthetics.overview.actions.runTestManually.title', {
  defaultMessage: 'Run test manually'
});
const openActionsMenuAria = _i18n.i18n.translate('xpack.synthetics.overview.actions.openPopover.ariaLabel', {
  defaultMessage: 'Open actions menu'
});
const actionsMenuTitle = _i18n.i18n.translate('xpack.synthetics.overview.actions.menu.title', {
  defaultMessage: 'Actions',
  description: 'This is the text in the heading of a menu containing a set of actions'
});
const actionsMenuGoToMonitorName = _i18n.i18n.translate('xpack.synthetics.overview.actions.goToMonitor.name', {
  defaultMessage: 'Go to monitor',
  description: 'This is the text for a menu item that will take the user to the monitor detail page'
});
const actionsMenuEditMonitorName = _i18n.i18n.translate('xpack.synthetics.overview.actions.editMonitor.name', {
  defaultMessage: 'Edit monitor',
  description: 'This is the text for a menu item that will take the user to the monitor edit page'
});
const actionsMenuCloneMonitorName = _i18n.i18n.translate('xpack.synthetics.overview.actions.cloneMonitor.name', {
  defaultMessage: 'Clone monitor'
});
const CREATE_SLO = _i18n.i18n.translate('xpack.synthetics.overview.actions.createSlo.name', {
  defaultMessage: 'Create SLO'
});
const loadingLabel = isEnabled => isEnabled ? _i18n.i18n.translate('xpack.synthetics.overview.actions.disablingLabel', {
  defaultMessage: 'Disabling monitor'
}) : _i18n.i18n.translate('xpack.synthetics.overview.actions.enablingLabel', {
  defaultMessage: 'Enabling monitor'
});
const enableMonitorLabel = _i18n.i18n.translate('xpack.synthetics.overview.actions.enableLabelEnableMonitor', {
  defaultMessage: 'Enable monitor (all locations)'
});
const disableMonitorLabel = _i18n.i18n.translate('xpack.synthetics.overview.actions.enableLabelDisableMonitor', {
  defaultMessage: 'Disable monitor (all locations)'
});
const disableAlertLabel = _i18n.i18n.translate('xpack.synthetics.overview.actions.disableLabelDisableAlert', {
  defaultMessage: 'Disable status alerts (all locations)'
});
const enableMonitorAlertLabel = _i18n.i18n.translate('xpack.synthetics.overview.actions.enableLabelDisableAlert', {
  defaultMessage: 'Enable status alerts (all locations)'
});
const addMonitorToDashboardLabel = _i18n.i18n.translate('xpack.synthetics.overview.actions.addToDashboard', {
  defaultMessage: 'Add to dashboard'
});
const enabledSuccessLabel = name => _i18n.i18n.translate('xpack.synthetics.overview.actions.enabledSuccessLabel', {
  defaultMessage: 'Monitor "{name}" enabled successfully',
  values: {
    name
  }
});
const disabledSuccessLabel = name => _i18n.i18n.translate('xpack.synthetics.overview.actions.disabledSuccessLabel', {
  defaultMessage: 'Monitor "{name}" disabled successfully.',
  values: {
    name
  }
});
exports.disabledSuccessLabel = disabledSuccessLabel;
const enabledFailLabel = name => _i18n.i18n.translate('xpack.synthetics.overview.actions.enabledFailLabel', {
  defaultMessage: 'Unable to update monitor "{name}".',
  values: {
    name
  }
});
exports.enabledFailLabel = enabledFailLabel;