"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorListColumns = useMonitorListColumns;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _lodash = require("lodash");
var _use_kibana_space = require("../../../../../../hooks/use_kibana_space");
var _hooks = require("../../../../hooks");
var _use_capabilities = require("../../../../../../hooks/use_capabilities");
var _alert_config = require("../../../../../../../common/runtime_types/monitor_management/alert_config");
var _permissions = require("../../../common/components/permissions");
var _use_monitor_alert_enable = require("../../../../hooks/use_monitor_alert_enable");
var _labels = _interopRequireWildcard(require("./labels"));
var labels = _labels;
var _monitor_details_link = require("./monitor_details_link");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _monitor_type_badge = require("../../../common/components/monitor_type_badge");
var _monitor_enabled = require("./monitor_enabled");
var _monitor_locations = require("./monitor_locations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/management/monitor_list_table/columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useMonitorListColumns({
  loading,
  overviewStatus,
  setMonitorPendingDeletion
}) {
  var _useKibana$services$a, _useKibana$services, _useKibana$services$a2, _spaces$ui$components, _overviewStatus$proje;
  const history = (0, _reactRouterDom.useHistory)();
  const {
    http,
    spaces
  } = (0, _public2.useKibana)().services;
  const canEditSynthetics = (0, _use_capabilities.useCanEditSynthetics)();
  const {
    isServiceAllowed
  } = (0, _hooks.useEnablement)();
  const {
    space
  } = (0, _use_kibana_space.useKibanaSpace)();
  const {
    alertStatus,
    updateAlertEnabledState
  } = (0, _use_monitor_alert_enable.useMonitorAlertEnable)();
  const isActionLoading = fields => {
    return alertStatus(fields[_runtime_types.ConfigKey.CONFIG_ID]) === _public.FETCH_STATUS.LOADING;
  };
  const canUsePublicLocations = (_useKibana$services$a = (_useKibana$services = (0, _public2.useKibana)().services) === null || _useKibana$services === void 0 ? void 0 : (_useKibana$services$a2 = _useKibana$services.application) === null || _useKibana$services$a2 === void 0 ? void 0 : _useKibana$services$a2.capabilities.uptime.elasticManagedLocationsEnabled) !== null && _useKibana$services$a !== void 0 ? _useKibana$services$a : true;
  const isPublicLocationsAllowed = fields => {
    const publicLocations = fields.locations.some(loc => loc.isServiceManaged);
    return publicLocations ? Boolean(canUsePublicLocations) : true;
  };
  const LazySpaceList = (_spaces$ui$components = spaces === null || spaces === void 0 ? void 0 : spaces.ui.components.getSpaceList) !== null && _spaces$ui$components !== void 0 ? _spaces$ui$components : () => null;
  const columns = [{
    align: 'left',
    field: _runtime_types.ConfigKey.NAME,
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.monitorName', {
      defaultMessage: 'Monitor'
    }),
    sortable: true,
    render: (_, monitor) => /*#__PURE__*/_react.default.createElement(_monitor_details_link.MonitorDetailsLink, {
      monitor: monitor,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    })
  },
  // Only show Project ID column if project monitors are present
  ...(((_overviewStatus$proje = overviewStatus === null || overviewStatus === void 0 ? void 0 : overviewStatus.projectMonitorsCount) !== null && _overviewStatus$proje !== void 0 ? _overviewStatus$proje : 0 > 0) ? [{
    align: 'left',
    field: _runtime_types.ConfigKey.PROJECT_ID,
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.projectId', {
      defaultMessage: 'Project ID'
    }),
    sortable: true
  }] : []), {
    align: 'left',
    field: _runtime_types.ConfigKey.MONITOR_TYPE,
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.monitorType', {
      defaultMessage: 'Type'
    }),
    sortable: true,
    render: (_, monitor) => /*#__PURE__*/_react.default.createElement(_monitor_type_badge.MonitorTypeBadge, {
      monitorType: monitor[_runtime_types.ConfigKey.MONITOR_TYPE],
      ariaLabel: labels.getFilterForTypeMessage(monitor[_runtime_types.ConfigKey.MONITOR_TYPE]),
      onClick: () => {
        history.push({
          search: `monitorTypes=${encodeURIComponent(JSON.stringify([monitor[_runtime_types.ConfigKey.MONITOR_TYPE]]))}`
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 9
      }
    })
  }, {
    align: 'left',
    field: _runtime_types.ConfigKey.SCHEDULE,
    sortable: true,
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.frequency', {
      defaultMessage: 'Frequency'
    }),
    render: schedule => (0, _labels.getFrequencyLabel)(schedule)
  }, {
    align: 'left',
    field: _runtime_types.ConfigKey.LOCATIONS,
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.locations', {
      defaultMessage: 'Locations'
    }),
    render: (locations, monitor) => {
      var _monitor$ConfigKey$CO;
      return locations ? /*#__PURE__*/_react.default.createElement(_monitor_locations.MonitorLocations, {
        monitorId: (_monitor$ConfigKey$CO = monitor[_runtime_types.ConfigKey.CONFIG_ID]) !== null && _monitor$ConfigKey$CO !== void 0 ? _monitor$ConfigKey$CO : monitor.id,
        locations: locations,
        overviewStatus: overviewStatus,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 11
        }
      }) : null;
    }
  }, {
    align: 'left',
    field: _runtime_types.ConfigKey.TAGS,
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.tags', {
      defaultMessage: 'Tags'
    }),
    render: tags => /*#__PURE__*/_react.default.createElement(_public.TagsList, {
      tags: tags,
      onClick: tag => {
        history.push({
          search: `tags=${encodeURIComponent(JSON.stringify([tag]))}`
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 9
      }
    })
  }, {
    align: 'left',
    field: _runtime_types.ConfigKey.ENABLED,
    sortable: true,
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.enabled', {
      defaultMessage: 'Enabled'
    }),
    render: (_enabled, monitor) => /*#__PURE__*/_react.default.createElement(_monitor_enabled.MonitorEnabled, {
      configId: monitor[_runtime_types.ConfigKey.CONFIG_ID],
      monitor: monitor,
      reloadPage: () => {},
      isSwitchable: !loading,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 9
      }
    })
  }, {
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.spacesColumnTitle', {
      defaultMessage: 'Spaces'
    }),
    field: 'spaces',
    sortable: false,
    render: monSpaces => {
      return /*#__PURE__*/_react.default.createElement(LazySpaceList, {
        namespaces: monSpaces !== null && monSpaces !== void 0 ? monSpaces : space ? [space === null || space === void 0 ? void 0 : space.id] : [],
        behaviorContext: "outside-space",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 11
        }
      });
    }
  }, {
    align: 'right',
    name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.actions', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      'data-test-subj': 'syntheticsMonitorEditAction',
      isPrimary: true,
      name: fields => /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
        canEditSynthetics: canEditSynthetics,
        canUsePublicLocations: isPublicLocationsAllowed(fields),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        "aria-label": _i18n.i18n.translate('xpack.synthetics.management.monitorList.editLabel', {
          defaultMessage: 'Edit monitor {monitorName}',
          values: {
            monitorName: fields[_runtime_types.ConfigKey.NAME]
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 207,
          columnNumber: 15
        }
      }, labels.EDIT_LABEL)),
      description: labels.EDIT_LABEL,
      icon: 'pencil',
      type: 'icon',
      enabled: fields => canEditSynthetics && !isActionLoading(fields) && isPublicLocationsAllowed(fields) && isServiceAllowed,
      href: fields => {
        const appendSpaceId = (0, _hooks.getMonitorSpaceToAppend)(space, fields.spaces);
        if (!(0, _lodash.isEmpty)(appendSpaceId)) {
          var _fields$spaces;
          return http === null || http === void 0 ? void 0 : http.basePath.prepend(`edit-monitor/${fields[_runtime_types.ConfigKey.CONFIG_ID]}?spaceId=${(_fields$spaces = fields.spaces) === null || _fields$spaces === void 0 ? void 0 : _fields$spaces[0]}`);
        }
        return http === null || http === void 0 ? void 0 : http.basePath.prepend(`edit-monitor/${fields[_runtime_types.ConfigKey.CONFIG_ID]}`);
      }
    }, {
      'data-test-subj': 'syntheticsMonitorCopyAction',
      isPrimary: false,
      name: fields => /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
        canEditSynthetics: canEditSynthetics,
        canUsePublicLocations: isPublicLocationsAllowed(fields),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 241,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        "aria-label": _i18n.i18n.translate('xpack.synthetics.management.monitorList.cloneLabel', {
          defaultMessage: 'Clone monitor {monitorName}',
          values: {
            monitorName: fields[_runtime_types.ConfigKey.NAME]
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 245,
          columnNumber: 15
        }
      }, labels.CLONE_LABEL)),
      description: labels.CLONE_LABEL,
      icon: 'copy',
      type: 'icon',
      enabled: fields => canEditSynthetics && !isActionLoading(fields) && isPublicLocationsAllowed(fields) && isServiceAllowed,
      href: fields => {
        return http === null || http === void 0 ? void 0 : http.basePath.prepend(`add-monitor?cloneId=${fields[_runtime_types.ConfigKey.CONFIG_ID]}`);
      }
    }, {
      'data-test-subj': 'syntheticsMonitorDeleteAction',
      isPrimary: true,
      name: fields => /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
        canEditSynthetics: canEditSynthetics,
        canUsePublicLocations: isPublicLocationsAllowed(fields),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 273,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        "aria-label": _i18n.i18n.translate('xpack.synthetics.management.monitorList.deleteLabel', {
          defaultMessage: 'Delete monitor {monitorName}',
          values: {
            monitorName: fields[_runtime_types.ConfigKey.NAME]
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 277,
          columnNumber: 15
        }
      }, labels.DELETE_LABEL)),
      description: labels.DELETE_LABEL,
      icon: 'trash',
      type: 'icon',
      color: 'danger',
      enabled: fields => canEditSynthetics && !isActionLoading(fields) && isPublicLocationsAllowed(fields),
      onClick: fields => {
        setMonitorPendingDeletion([fields[_runtime_types.ConfigKey.CONFIG_ID]]);
      }
    }, {
      description: labels.DISABLE_STATUS_ALERT,
      name: fields => /*#__PURE__*/_react.default.createElement("span", {
        "aria-label": (0, _alert_config.isStatusEnabled)(fields[_runtime_types.ConfigKey.ALERT_CONFIG]) ? _i18n.i18n.translate('xpack.synthetics.management.monitorList.disableAlert', {
          defaultMessage: 'Disable alert for {monitorName}',
          values: {
            monitorName: fields[_runtime_types.ConfigKey.NAME]
          }
        }) : _i18n.i18n.translate('xpack.synthetics.management.monitorList.enableAlert', {
          defaultMessage: 'Enable alert for {monitorName}',
          values: {
            monitorName: fields[_runtime_types.ConfigKey.NAME]
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 302,
          columnNumber: 13
        }
      }, (0, _alert_config.isStatusEnabled)(fields[_runtime_types.ConfigKey.ALERT_CONFIG]) ? labels.DISABLE_STATUS_ALERT : labels.ENABLE_STATUS_ALERT),
      icon: fields => (0, _alert_config.isStatusEnabled)(fields[_runtime_types.ConfigKey.ALERT_CONFIG]) ? 'bellSlash' : 'bell',
      type: 'icon',
      color: 'danger',
      enabled: fields => canEditSynthetics && !isActionLoading(fields) && isPublicLocationsAllowed(fields) && isServiceAllowed,
      onClick: fields => {
        updateAlertEnabledState({
          monitor: {
            [_runtime_types.ConfigKey.ALERT_CONFIG]: (0, _alert_config.toggleStatusAlert)(fields[_runtime_types.ConfigKey.ALERT_CONFIG])
          },
          name: fields[_runtime_types.ConfigKey.NAME],
          configId: fields[_runtime_types.ConfigKey.CONFIG_ID]
        });
      }
    }]
  }];
  if (!canEditSynthetics) {
    // replace last column with a tooltip
    columns[columns.length - 1] = {
      align: 'right',
      name: _i18n.i18n.translate('xpack.synthetics.management.monitorList.actions', {
        defaultMessage: 'Actions'
      }),
      render: () => /*#__PURE__*/_react.default.createElement(_permissions.NoPermissionsTooltip, {
        canEditSynthetics: canEditSynthetics,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 351,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": "syntheticsUseMonitorListColumnsButton",
        iconType: "boxesHorizontal",
        isDisabled: true,
        "aria-label": _permissions.CANNOT_PERFORM_ACTION_SYNTHETICS,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 352,
          columnNumber: 11
        }
      }))
    };
  }
  return columns;
}