"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TEST_RUNS_LABEL = exports.SYNTHETICS_ENABLE_LABEL = exports.SUMMARY_LABEL = exports.LOADING_LABEL = exports.LEARN_MORE_LABEL = exports.ERROR_HEADING_LABEL = exports.ERROR_HEADING_BODY = exports.DISABLED_LABEL = exports.CONFIGURATIONS_LABEL = exports.CALLOUT_MANAGEMENT_DISABLED = exports.CALLOUT_MANAGEMENT_DESCRIPTION = exports.CALLOUT_MANAGEMENT_CONTACT_ADMIN = void 0;
exports.getLastXDaysLabel = getLastXDaysLabel;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOADING_LABEL = exports.LOADING_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.manageMonitorLoadingLabel', {
  defaultMessage: 'Loading Synthetics App'
});
const LEARN_MORE_LABEL = exports.LEARN_MORE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.manageMonitorLoadingLabel.callout.learnMore', {
  defaultMessage: 'Learn more.'
});
const CALLOUT_MANAGEMENT_DISABLED = exports.CALLOUT_MANAGEMENT_DISABLED = _i18n.i18n.translate('xpack.synthetics.monitorManagement.callout.disabled', {
  defaultMessage: 'Synthetics App is currently disabled'
});
const CALLOUT_MANAGEMENT_CONTACT_ADMIN = exports.CALLOUT_MANAGEMENT_CONTACT_ADMIN = _i18n.i18n.translate('xpack.synthetics.monitorManagement.callout.disabled.adminContact', {
  defaultMessage: 'Synthetics App will be enabled when an admin visits the Synthetics app.'
});
const CALLOUT_MANAGEMENT_DESCRIPTION = exports.CALLOUT_MANAGEMENT_DESCRIPTION = _i18n.i18n.translate('xpack.synthetics.monitorManagement.callout.description.disabled', {
  defaultMessage: "Synthetics App requires a valid API key to run your monitors on Elastic's global managed testing locations. If you already had enabled Synthetics App previously, the API key may no longer be valid."
});
const ERROR_HEADING_BODY = exports.ERROR_HEADING_BODY = _i18n.i18n.translate('xpack.synthetics.monitorManagement.editMonitorError.description', {
  defaultMessage: 'Synthetics App settings could not be loaded. Please contact Support.'
});
const SYNTHETICS_ENABLE_LABEL = exports.SYNTHETICS_ENABLE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.syntheticsEnableLabel.management', {
  defaultMessage: 'Enable Synthetics App'
});
const ERROR_HEADING_LABEL = exports.ERROR_HEADING_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.editMonitorError', {
  defaultMessage: 'Error loading Synthetics App'
});
const SUMMARY_LABEL = exports.SUMMARY_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.summary.heading', {
  defaultMessage: 'Summary'
});
const CONFIGURATIONS_LABEL = exports.CONFIGURATIONS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.configurations.label', {
  defaultMessage: 'Configurations'
});
const DISABLED_LABEL = exports.DISABLED_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.disabled.label', {
  defaultMessage: 'Disabled'
});
const TEST_RUNS_LABEL = exports.TEST_RUNS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorManagement.testRuns.label', {
  defaultMessage: 'Test runs'
});
function getLastXDaysLabel(count) {
  return _i18n.i18n.translate('xpack.synthetics.monitorManagement.lastXDays', {
    defaultMessage: 'Last {count, number} {count, plural, one {day} other {days}}',
    values: {
      count
    }
  });
}