"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVICE_NOT_ALLOWED = exports.DisabledCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var labels = _interopRequireWildcard(require("./labels"));
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/synthetics/public/apps/synthetics/components/monitors_page/management/disabled_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DisabledCallout = ({
  total
}) => {
  const {
    isEnabled,
    invalidApiKeyError,
    loading,
    isServiceAllowed,
    canEnable
  } = (0, _hooks.useEnablement)();
  const showDisableCallout = !isEnabled && total && total > 0;
  const showInvalidApiKeyCallout = invalidApiKeyError && total && total > 0;
  if (!showDisableCallout && !showInvalidApiKeyCallout && isServiceAllowed || loading) {
    return null;
  }
  const disabledCallout = !canEnable && showDisableCallout && !loading ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: labels.CALLOUT_MANAGEMENT_DISABLED,
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 11
    }
  }, labels.CALLOUT_MANAGEMENT_DESCRIPTION), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 11
    }
  }, labels.CALLOUT_MANAGEMENT_CONTACT_ADMIN, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsMonitorManagementPageLink",
    href: "https://www.elastic.co/guide/en/observability/current/synthetics-get-started-ui.html#uptime-set-up-prereq",
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 13
    }
  }, labels.LEARN_MORE_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  })) : null;
  const disAllowedCallout = !isServiceAllowed ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: ACCOUNT_BLOCKED,
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, SERVICE_NOT_ALLOWED)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  })) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, disabledCallout, disAllowedCallout);
};
exports.DisabledCallout = DisabledCallout;
const SERVICE_NOT_ALLOWED = exports.SERVICE_NOT_ALLOWED = _i18n.i18n.translate('xpack.synthetics.synthetics.serviceNotAllowed', {
  defaultMessage: 'Account is blocked from using Elastic managed locations, please contact support. Your monitors have been paused.'
});
const ACCOUNT_BLOCKED = _i18n.i18n.translate('xpack.synthetics.synthetics.accountBlocked', {
  defaultMessage: 'Account is blocked.'
});